/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Sound;
import com.anotherbigidea.flash.sound.ADPCMEncodeStream;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import com.anotherbigidea.io.OutStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class ADPCMHelper {
    protected AudioInputStream audioIn;
    protected boolean isStereo;
    protected boolean is16Bit;
    protected int sampleRate;
    protected int rate;
    protected int samplesPerFrame;
    protected boolean isSigned;
    protected int sampleCount = 0;
    protected ADPCMEncodeStream leftEncoder;
    protected ADPCMEncodeStream rightEncoder;
    protected ADPCMPacket currentPacket;

    public ADPCMHelper(InputStream audioFile, int framesPerSecond) throws IOException, UnsupportedAudioFileException {
        this.audioIn = AudioSystem.getAudioInputStream(new BufferedInputStream(audioFile));
        AudioFormat format = this.audioIn.getFormat();
        int frameSize = format.getFrameSize();
        this.isStereo = format.getChannels() == 2;
        this.is16Bit = format.getSampleSizeInBits() > 8;
        this.sampleRate = (int)format.getSampleRate();
        boolean bl = this.isSigned = format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        this.sampleRate = this.sampleRate >= 44000 ? 44000 : (this.sampleRate >= 22000 ? 22000 : (this.sampleRate >= 11000 ? 11000 : 5500));
        this.rate = 0;
        if (this.sampleRate == 44000) {
            this.rate = 3;
        } else if (this.sampleRate == 22000) {
            this.rate = 2;
        } else if (this.sampleRate == 11000) {
            this.rate = 1;
        }
        this.samplesPerFrame = this.sampleRate / framesPerSecond;
        FramedInputStream frameIn = new FramedInputStream(this.audioIn, frameSize);
        this.leftEncoder = new ADPCMEncodeStream(frameIn, this.is16Bit, this.isSigned);
        if (this.isStereo) {
            this.rightEncoder = new ADPCMEncodeStream(frameIn, this.is16Bit, this.isSigned);
        }
    }

    public Sound getSoundDefinition() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutStream out = new OutStream(bout);
        this.sampleCount = 0;
        boolean first = true;
        ADPCMPacket packet = this.readPacket(4096);
        while (packet != null) {
            this.sampleCount += packet.sampleCount + 1;
            this.writePacket(packet, out, first);
            first = false;
            packet = this.readPacket(4096);
        }
        out.flush();
        byte[] soundData = bout.toByteArray();
        return new Sound(1, this.rate, true, this.isStereo, this.sampleCount, soundData);
    }

    public ADPCMPacket readPacket(int packetSize) throws IOException {
        ADPCMPacket packet = new ADPCMPacket();
        packet.initialLeftSample = this.leftEncoder.getFirstPacketSample();
        if (this.leftEncoder.isDone()) {
            return null;
        }
        int count = 0;
        if (this.isStereo) {
            packet.initialRightSample = this.rightEncoder.getFirstPacketSample();
        }
        packet.initialLeftIndex = this.leftEncoder.setIndex(packet.initialLeftSample);
        if (this.isStereo) {
            packet.initialRightIndex = this.rightEncoder.setIndex(packet.initialRightSample);
        }
        packet.leftData = new int[packetSize - 1];
        if (this.isStereo) {
            packet.rightData = new int[packetSize - 1];
        }
        for (int i = 0; i < packetSize - 1; ++i) {
            packet.leftData[i] = this.leftEncoder.getDelta();
            if (!this.leftEncoder.isDone()) {
                ++count;
            }
            if (!this.isStereo) continue;
            packet.rightData[i] = this.rightEncoder.getDelta();
        }
        packet.sampleCount = count;
        return packet;
    }

    public byte[] getBlockData(boolean firstBlock) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutStream os = new OutStream(bout);
        this.currentPacket = this.readPacket(this.samplesPerFrame);
        if (this.currentPacket == null) {
            return null;
        }
        this.writePacket(this.currentPacket, os, true);
        os.flushBits();
        return bout.toByteArray();
    }

    public void writePacket(ADPCMPacket packet, OutStream out, boolean includeBitCount) throws IOException {
        if (packet == null) {
            return;
        }
        int sample = packet.initialLeftSample;
        if (includeBitCount) {
            out.writeUBits(2, 2L);
        }
        out.writeUBits(16, sample);
        out.writeUBits(6, packet.initialLeftIndex);
        if (this.isStereo) {
            sample = packet.initialRightSample;
            out.writeUBits(16, sample);
            out.writeUBits(6, packet.initialRightIndex);
        }
        for (int i = 0; i < packet.sampleCount; ++i) {
            out.writeUBits(4, packet.leftData[i]);
            if (!this.isStereo) continue;
            out.writeUBits(4, packet.rightData[i]);
        }
    }

    public SoundStreamHead getStreamHeader() {
        return new SoundStreamHead(this.rate, true, this.isStereo, 1, this.rate, true, this.isStereo, this.samplesPerFrame);
    }

    public static void main(String[] args) throws Exception {
        FileInputStream audioFile = new FileInputStream(args[0]);
        Movie movie = new Movie();
        movie.setFrameRate(30);
        ADPCMHelper helper = new ADPCMHelper(audioFile, 30);
        Frame frame = movie.appendFrame();
        Sound sound = helper.getSoundDefinition();
        int frames = frame.startSound(sound, 30);
        while (frames-- > 0) {
            frame = movie.appendFrame();
        }
        frame.stop();
        ((InputStream)audioFile).close();
        movie.write(args[1]);
    }

    public static void main2(String[] args) throws Exception {
        FileInputStream audioFile = new FileInputStream(args[0]);
        SWFWriter swfwriter = new SWFWriter(args[1]);
        TagWriter tags = new TagWriter(swfwriter);
        tags.header(5, -1L, 200, 200, 12, -1);
        tags.tagSetBackgroundColor(new Color(255, 255, 255));
        ADPCMHelper helper = new ADPCMHelper(audioFile, 12);
        SoundStreamHead header = helper.getStreamHeader();
        header.write(tags);
        byte[] block = helper.getBlockData(true);
        while (block != null) {
            tags.tagSoundStreamBlock(block);
            tags.tagShowFrame();
            block = helper.getBlockData(false);
        }
        SWFActions acts = tags.tagDoAction();
        acts.start(0);
        acts.stop();
        acts.end();
        acts.done();
        tags.tagShowFrame();
        tags.tagEnd();
        ((InputStream)audioFile).close();
    }

    public static class FramedInputStream
    extends InputStream {
        protected InputStream in;
        protected byte[] frameData;
        protected int dataPtr;
        protected int frameSize;
        protected boolean done = false;

        public FramedInputStream(InputStream in, int frameSize) {
            this.in = in;
            this.frameSize = frameSize;
            this.frameData = new byte[frameSize];
            this.dataPtr = frameSize;
        }

        @Override
        public int read() throws IOException {
            if (this.dataPtr < this.frameData.length) {
                int val;
                if ((val = this.frameData[this.dataPtr++]) < 0) {
                    val += 256;
                }
                return val;
            }
            if (this.done) {
                return -1;
            }
            this.dataPtr = 0;
            int read = 0;
            while (this.dataPtr < this.frameSize && (read = this.in.read(this.frameData, this.dataPtr, this.frameSize - this.dataPtr)) >= 0) {
                this.dataPtr += read;
            }
            if (this.dataPtr == 0) {
                this.done = true;
                return -1;
            }
            while (this.dataPtr < this.frameData.length) {
                this.frameData[this.dataPtr++] = 0;
            }
            this.dataPtr = 0;
            return this.read();
        }
    }

    public class ADPCMPacket {
        public int initialLeftSample = 0;
        public int initialLeftIndex = 0;
        public int initialRightSample = 0;
        public int initialRightIndex = 0;
        public int[] leftData;
        public int[] rightData;
        public int sampleCount;
    }
}

