/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.writers.TagWriter;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ActionWriter
implements SWFActions,
SWFActionCodes {
    protected TagWriter tagWriter;
    protected OutStream out;
    protected ByteArrayOutputStream bout;
    protected int count;
    protected int flashVersion;
    protected String mStringEncoding;
    protected Vector pushValues;
    protected Hashtable labels;
    protected Vector jumps;
    protected Vector skips;
    protected Vector blocks;
    protected Stack blockStack;

    public ActionWriter(TagWriter tagWriter, int flashVersion) {
        this.flashVersion = flashVersion;
        this.tagWriter = tagWriter;
        this.mStringEncoding = flashVersion >= 6 ? "UTF-8" : "US-ASCII";
    }

    protected int writeCode(int code) throws IOException {
        if (this.pushValues.size() > 0) {
            this.flushPushValues();
        }
        this.out.writeUI8(code);
        ++this.count;
        return this.count;
    }

    @Override
    public void start(int conditions) throws IOException {
        this.count = 0;
        this.bout = new ByteArrayOutputStream();
        this.out = new OutStream(this.bout);
        this.pushValues = new Vector();
        this.labels = null;
        this.jumps = null;
        this.skips = null;
        this.blocks = null;
        this.blockStack = null;
    }

    @Override
    public void end() throws IOException {
        this.writeCode(0);
        this.out.flush();
        byte[] bytes = this.bout.toByteArray();
        if (this.labels != null) {
            if (this.jumps != null) {
                this.fixupJumps(bytes);
            }
            if (this.skips != null) {
                this.fixupSkips(bytes);
            }
        }
        if (this.blocks != null) {
            this.fixupBlocks(bytes);
        }
        this.writeBytes(bytes);
    }

    @Override
    public void blob(byte[] blob) throws IOException {
        this.writeBytes(blob);
    }

    protected void writeBytes(byte[] bytes) throws IOException {
        this.tagWriter.getOutStream().write(bytes);
    }

    @Override
    public void done() throws IOException {
        this.tagWriter.completeTag();
    }

    protected void fixupBlocks(byte[] bytes) {
        Enumeration enum_ = this.blocks.elements();
        while (enum_.hasMoreElements()) {
            int[] info = (int[])enum_.nextElement();
            int codeSize = info[1];
            int offset = info[0];
            byte[] sizeBytes = OutStream.sintTo2Bytes(codeSize);
            bytes[offset] = sizeBytes[0];
            bytes[offset + 1] = sizeBytes[1];
        }
    }

    protected void fixupJumps(byte[] bytes) {
        Enumeration enum_ = this.jumps.elements();
        while (enum_.hasMoreElements()) {
            Object[] obja = (Object[])enum_.nextElement();
            String label = (String)obja[0];
            int target = (Integer)obja[1];
            int[] labelInfo = (int[])this.labels.get(label);
            if (labelInfo == null) {
                System.out.println("Missing label '" + label + "' in action code");
                continue;
            }
            int absolute = labelInfo[0];
            int relative = absolute - (target + 2);
            byte[] val = OutStream.sintTo2Bytes(relative);
            bytes[target] = val[0];
            bytes[target + 1] = val[1];
        }
    }

    protected void fixupSkips(byte[] bytes) {
        Enumeration enum_ = this.skips.elements();
        while (enum_.hasMoreElements()) {
            byte val;
            Object[] obja = (Object[])enum_.nextElement();
            String label = (String)obja[0];
            int[] skipInfo = (int[])obja[1];
            int skipIndex = skipInfo[0];
            int skipLoc = skipInfo[1];
            int[] labelInfo = (int[])this.labels.get(label);
            if (labelInfo == null) {
                System.out.println("Missing label '" + label + "' in action code");
                continue;
            }
            int labelIndex = labelInfo[1];
            int skip = labelIndex - skipIndex - 1;
            bytes[skipLoc] = val = OutStream.uintToByte(skip);
        }
    }

    @Override
    public void comment(String comment) throws IOException {
    }

    @Override
    public void unknown(int code, byte[] data) throws IOException {
        int length;
        this.writeCode(code);
        int n = length = data != null ? data.length : 0;
        if (code >= 128 || length > 0) {
            this.out.writeUI16(length);
        }
        if (length > 0) {
            this.out.write(data);
        }
    }

    @Override
    public void initArray() throws IOException {
        this.writeCode(66);
    }

    @Override
    public void jumpLabel(String label) throws IOException {
        if (this.pushValues.size() > 0) {
            this.flushPushValues();
        }
        int offset = this.out.getCount();
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        this.labels.put(label, new int[]{offset, this.count + 1});
    }

    @Override
    public void gotoFrame(int frameNumber) throws IOException {
        this.writeCode(129);
        this.out.writeUI16(2);
        this.out.writeUI16(frameNumber);
    }

    @Override
    public void gotoFrame(String label) throws IOException {
        this.writeCode(140);
        this.out.writeUI16(OutStream.getStringLength(label));
        this.out.writeString(label, this.mStringEncoding);
    }

    @Override
    public void getURL(String url, String target) throws IOException {
        this.writeCode(131);
        this.out.writeUI16(OutStream.getStringLength(url) + OutStream.getStringLength(target));
        this.out.writeString(url, this.mStringEncoding);
        this.out.writeString(target, this.mStringEncoding);
    }

    @Override
    public void nextFrame() throws IOException {
        this.writeCode(4);
    }

    @Override
    public void prevFrame() throws IOException {
        this.writeCode(5);
    }

    @Override
    public void play() throws IOException {
        this.writeCode(6);
    }

    @Override
    public void stop() throws IOException {
        this.writeCode(7);
    }

    @Override
    public void toggleQuality() throws IOException {
        this.writeCode(8);
    }

    @Override
    public void stopSounds() throws IOException {
        this.writeCode(9);
    }

    @Override
    public void setTarget(String target) throws IOException {
        this.writeCode(139);
        this.out.writeUI16(OutStream.getStringLength(target));
        this.out.writeString(target, this.mStringEncoding);
    }

    protected void writeJump(String label, int code) throws IOException {
        this.writeCode(code);
        this.out.writeUI16(2);
        int here = this.out.getCount();
        this.out.writeUI16(0);
        if (this.jumps == null) {
            this.jumps = new Vector();
        }
        this.jumps.addElement(new Object[]{label, new Integer(here)});
    }

    @Override
    public void jump(String jumpLabel) throws IOException {
        this.writeJump(jumpLabel, 153);
    }

    @Override
    public void ifJump(String jumpLabel) throws IOException {
        this.writeJump(jumpLabel, 157);
    }

    @Override
    public void waitForFrame(int frameNumber, String jumpLabel) throws IOException {
        this.writeCode(138);
        this.out.writeUI16(3);
        this.out.writeUI16(frameNumber);
        int here = this.out.getCount();
        this.out.writeUI8(0);
        if (this.skips == null) {
            this.skips = new Vector();
        }
        this.skips.addElement(new Object[]{jumpLabel, new int[]{this.count, here}});
    }

    @Override
    public void waitForFrame(String jumpLabel) throws IOException {
        this.writeCode(141);
        this.out.writeUI16(1);
        int here = this.out.getCount();
        this.out.writeUI8(0);
        if (this.skips == null) {
            this.skips = new Vector();
        }
        this.skips.addElement(new Object[]{jumpLabel, new int[]{this.count, here}});
    }

    @Override
    public void pop() throws IOException {
        this.writeCode(23);
    }

    @Override
    public void add() throws IOException {
        this.writeCode(10);
    }

    @Override
    public void substract() throws IOException {
        this.writeCode(11);
    }

    @Override
    public void multiply() throws IOException {
        this.writeCode(12);
    }

    @Override
    public void divide() throws IOException {
        this.writeCode(13);
    }

    @Override
    public void equals() throws IOException {
        this.writeCode(14);
    }

    @Override
    public void lessThan() throws IOException {
        this.writeCode(15);
    }

    @Override
    public void and() throws IOException {
        this.writeCode(16);
    }

    @Override
    public void or() throws IOException {
        this.writeCode(17);
    }

    @Override
    public void not() throws IOException {
        this.writeCode(18);
    }

    @Override
    public void stringEquals() throws IOException {
        this.writeCode(19);
    }

    @Override
    public void stringLength() throws IOException {
        this.writeCode(20);
    }

    @Override
    public void concat() throws IOException {
        this.writeCode(33);
    }

    @Override
    public void substring() throws IOException {
        this.writeCode(21);
    }

    @Override
    public void stringLessThan() throws IOException {
        this.writeCode(41);
    }

    @Override
    public void stringLengthMB() throws IOException {
        this.writeCode(49);
    }

    @Override
    public void substringMB() throws IOException {
        this.writeCode(53);
    }

    @Override
    public void toInteger() throws IOException {
        this.writeCode(24);
    }

    @Override
    public void charToAscii() throws IOException {
        this.writeCode(50);
    }

    @Override
    public void asciiToChar() throws IOException {
        this.writeCode(51);
    }

    @Override
    public void charMBToAscii() throws IOException {
        this.writeCode(54);
    }

    @Override
    public void asciiToCharMB() throws IOException {
        this.writeCode(55);
    }

    @Override
    public void call() throws IOException {
        this.writeCode(158);
        this.out.writeUI16(0);
    }

    @Override
    public void getVariable() throws IOException {
        this.writeCode(28);
    }

    @Override
    public void setVariable() throws IOException {
        this.writeCode(29);
    }

    @Override
    public void getURL(int sendVars, int loadMode) throws IOException {
        this.writeCode(154);
        this.out.writeUI16(1);
        int flags = 0;
        Object sendVars_ = null;
        switch (sendVars) {
            case 1: {
                flags = 1;
                break;
            }
            case 2: {
                flags = 2;
                break;
            }
        }
        Object mode = null;
        switch (loadMode) {
            case 0: {
                break;
            }
            case 1: {
                flags |= 0x40;
                break;
            }
            case 3: {
                flags |= 0x80;
                break;
            }
            case 4: {
                flags |= 0xC0;
                break;
            }
        }
        this.out.writeUI8(flags);
    }

    @Override
    public void gotoFrame(boolean play) throws IOException {
        this.writeCode(159);
        this.out.writeUI16(1);
        this.out.writeUI8(play ? 1 : 0);
    }

    @Override
    public void setTarget() throws IOException {
        this.writeCode(32);
    }

    @Override
    public void getProperty() throws IOException {
        this.writeCode(34);
    }

    @Override
    public void setProperty() throws IOException {
        this.writeCode(35);
    }

    @Override
    public void cloneSprite() throws IOException {
        this.writeCode(36);
    }

    @Override
    public void removeSprite() throws IOException {
        this.writeCode(37);
    }

    @Override
    public void startDrag() throws IOException {
        this.writeCode(39);
    }

    @Override
    public void endDrag() throws IOException {
        this.writeCode(40);
    }

    @Override
    public void trace() throws IOException {
        this.writeCode(38);
    }

    @Override
    public void getTime() throws IOException {
        this.writeCode(52);
    }

    @Override
    public void randomNumber() throws IOException {
        this.writeCode(48);
    }

    @Override
    public void lookupTable(String[] values) throws IOException {
        this.writeCode(136);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        OutStream bout = new OutStream(baout);
        bout.writeUI16(values.length);
        for (int i = 0; i < values.length; ++i) {
            bout.writeString(values[i], this.mStringEncoding);
        }
        bout.flush();
        byte[] data = baout.toByteArray();
        this.out.writeUI16(data.length);
        this.out.write(data);
    }

    @Override
    public void callFunction() throws IOException {
        this.writeCode(61);
    }

    @Override
    public void callMethod() throws IOException {
        this.writeCode(82);
    }

    @Override
    public void startFunction(String name, String[] paramNames) throws IOException {
        if (this.blockStack == null) {
            this.blockStack = new Stack();
        }
        this.writeCode(155);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        OutStream bout = new OutStream(baout);
        bout.writeString(name, this.mStringEncoding);
        bout.writeUI16(paramNames.length);
        for (int i = 0; i < paramNames.length; ++i) {
            bout.writeString(paramNames[i], this.mStringEncoding);
        }
        bout.writeUI16(0);
        bout.flush();
        byte[] data = baout.toByteArray();
        this.out.writeUI16(data.length);
        this.out.write(data);
        this.blockStack.push(new int[]{this.out.getCount(), 0});
    }

    @Override
    public void endBlock() throws IOException {
        if (this.blockStack == null || this.blockStack.isEmpty()) {
            return;
        }
        int[] blockInfo = (int[])this.blockStack.pop();
        if (this.blocks == null) {
            this.blocks = new Vector();
        }
        int offset = blockInfo[0];
        int codeSize = this.out.getCount() - offset;
        blockInfo[0] = offset - 2;
        blockInfo[1] = codeSize;
        this.blocks.addElement(blockInfo);
    }

    @Override
    public void defineLocalValue() throws IOException {
        this.writeCode(60);
    }

    @Override
    public void defineLocal() throws IOException {
        this.writeCode(65);
    }

    @Override
    public void deleteProperty() throws IOException {
        this.writeCode(58);
    }

    @Override
    public void deleteThreadVars() throws IOException {
        this.writeCode(59);
    }

    @Override
    public void enumerate() throws IOException {
        this.writeCode(70);
    }

    @Override
    public void typedEquals() throws IOException {
        this.writeCode(73);
    }

    @Override
    public void getMember() throws IOException {
        this.writeCode(78);
    }

    @Override
    public void initObject() throws IOException {
        this.writeCode(67);
    }

    @Override
    public void newMethod() throws IOException {
        this.writeCode(83);
    }

    @Override
    public void newObject() throws IOException {
        this.writeCode(64);
    }

    @Override
    public void setMember() throws IOException {
        this.writeCode(79);
    }

    @Override
    public void getTargetPath() throws IOException {
        this.writeCode(69);
    }

    @Override
    public void startWith() throws IOException {
        this.writeCode(148);
        this.out.writeUI16(2);
        this.out.writeUI16(0);
        if (this.blockStack == null) {
            this.blockStack = new Stack();
        }
        this.blockStack.push(new int[]{this.out.getCount(), 0});
    }

    @Override
    public void duplicate() throws IOException {
        this.writeCode(76);
    }

    @Override
    public void returnValue() throws IOException {
        this.writeCode(62);
    }

    @Override
    public void swap() throws IOException {
        this.writeCode(77);
    }

    @Override
    public void storeInRegister(int registerNumber) throws IOException {
        this.writeCode(135);
        this.out.writeUI16(1);
        this.out.writeUI8(registerNumber);
    }

    @Override
    public void convertToNumber() throws IOException {
        this.writeCode(74);
    }

    @Override
    public void convertToString() throws IOException {
        this.writeCode(75);
    }

    @Override
    public void typeOf() throws IOException {
        this.writeCode(68);
    }

    @Override
    public void typedAdd() throws IOException {
        this.writeCode(71);
    }

    @Override
    public void typedLessThan() throws IOException {
        this.writeCode(72);
    }

    @Override
    public void modulo() throws IOException {
        this.writeCode(63);
    }

    @Override
    public void bitAnd() throws IOException {
        this.writeCode(96);
    }

    @Override
    public void bitOr() throws IOException {
        this.writeCode(97);
    }

    @Override
    public void bitXor() throws IOException {
        this.writeCode(98);
    }

    @Override
    public void shiftLeft() throws IOException {
        this.writeCode(99);
    }

    @Override
    public void shiftRight() throws IOException {
        this.writeCode(100);
    }

    @Override
    public void shiftRightUnsigned() throws IOException {
        this.writeCode(101);
    }

    @Override
    public void decrement() throws IOException {
        this.writeCode(81);
    }

    @Override
    public void increment() throws IOException {
        this.writeCode(80);
    }

    protected void flushPushValues() throws IOException {
        this.out.writeUI8(150);
        ++this.count;
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        OutStream bout = new OutStream(baout);
        Enumeration enum_ = this.pushValues.elements();
        while (enum_.hasMoreElements()) {
            Object value = enum_.nextElement();
            if (value instanceof String) {
                bout.writeUI8(0);
                bout.writeString(value.toString(), this.mStringEncoding);
                continue;
            }
            if (value instanceof Boolean) {
                bout.writeUI8(5);
                bout.writeUI8((Boolean)value != false ? 1 : 0);
                continue;
            }
            if (value instanceof Integer) {
                bout.writeUI8(7);
                bout.writeSI32((Integer)value);
                continue;
            }
            if (value instanceof Short) {
                bout.writeUI8(8);
                bout.writeUI8(((Short)value).intValue());
                continue;
            }
            if (value instanceof Byte) {
                bout.writeUI8(4);
                bout.writeUI8(((Byte)value).intValue());
                continue;
            }
            if (value instanceof Float) {
                bout.writeUI8(1);
                bout.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                bout.writeUI8(6);
                bout.writeDouble((Double)value);
                continue;
            }
            bout.writeUI8(2);
        }
        this.pushValues.removeAllElements();
        bout.flush();
        byte[] data = baout.toByteArray();
        this.out.writeUI16(data.length);
        this.out.write(data);
    }

    @Override
    public void push(String value) throws IOException {
        this.pushValues.addElement(value);
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void push(float value) throws IOException {
        this.pushValues.addElement(new Float(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void push(double value) throws IOException {
        this.pushValues.addElement(new Double(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void pushNull() throws IOException {
        this.pushValues.addElement(new Object());
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void pushRegister(int registerNumber) throws IOException {
        this.pushValues.addElement(new Byte((byte)registerNumber));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void push(boolean value) throws IOException {
        this.pushValues.addElement(new Boolean(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void push(int value) throws IOException {
        this.pushValues.addElement(new Integer(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void lookup(int dictionaryIndex) throws IOException {
        this.pushValues.addElement(new Short((short)dictionaryIndex));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    @Override
    public void enumerateObject() throws IOException {
        this.writeCode(85);
    }

    @Override
    public void greaterThan() throws IOException {
        this.writeCode(103);
    }

    @Override
    public void instanceOf() throws IOException {
        this.writeCode(84);
    }

    @Override
    public void strictEquals() throws IOException {
        this.writeCode(102);
    }

    @Override
    public void stringGreaterThan() throws IOException {
        this.writeCode(104);
    }
}

