/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.writers.ActionTextWriter;
import com.anotherbigidea.util.Hex;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class SWFTagDumper
implements SWFTagTypes,
SWFShape,
SWFText,
SWFFileSignature {
    protected PrintWriter writer;
    protected String dashes = "---------------";
    protected boolean dumpHex;
    protected String indent = "";
    protected boolean decompileActions = false;

    public SWFTagDumper(boolean dumpHex, boolean decompileActions) {
        this(System.out, dumpHex, decompileActions);
    }

    public SWFTagDumper(OutputStream out, boolean dumpHex, boolean decompileActions) {
        this.writer = new PrintWriter(out);
        this.dumpHex = dumpHex;
        this.decompileActions = decompileActions;
    }

    public SWFTagDumper(PrintWriter writer, boolean dumpHex, boolean decompileActions) {
        this.writer = writer;
        this.dumpHex = dumpHex;
        this.decompileActions = decompileActions;
    }

    @Override
    public void signature(String sig) {
        this.println("signature: " + sig);
    }

    protected void println(String line) {
        this.writer.println(this.indent + line);
    }

    @Override
    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        this.println("Tag " + tagType + " length=" + contents.length);
        if (this.dumpHex) {
            Hex.dump(this.writer, contents, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.println("header: version=" + version + " length=" + length + " width=" + twipsWidth + " height=" + twipsHeight + " rate=" + frameRate + " frame-count=" + frameCount);
    }

    @Override
    public void tagEnd() throws IOException {
        this.println("end");
        this.println(this.dashes);
    }

    @Override
    public void tagStartSound(int soundId, SoundInfo info) throws IOException {
        this.println("start-sound id=" + soundId + " " + info);
    }

    @Override
    public void tagSoundStreamHead(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.printSoundStreamHead("sound-stream-head", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    @Override
    public void tagSoundStreamHead2(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.printSoundStreamHead("sound-stream-head-2", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void printSoundStreamHead(String name, int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        String playFreq = "5.5";
        if (playbackFrequency == 1) {
            playFreq = "11";
        }
        if (playbackFrequency == 2) {
            playFreq = "22";
        }
        if (playbackFrequency == 3) {
            playFreq = "44";
        }
        String streamFreq = "5.5";
        if (streamFrequency == 1) {
            streamFreq = "11";
        }
        if (streamFrequency == 2) {
            streamFreq = "22";
        }
        if (streamFrequency == 3) {
            streamFreq = "44";
        }
        String format = "RawSamples";
        if (streamFormat == 1) {
            format = "ADPCM";
        }
        if (streamFormat == 2) {
            format = "MP3";
        }
        this.println(name + " play at " + playFreq + "kHz stereo=" + playbackStereo + " 16bit=" + playback16bit + " | Stream at " + streamFreq + "kHz format=" + format + " stereo=" + streamStereo + " 16bit=" + stream16bit + " Avg-Samples=" + averageSampleCount);
    }

    @Override
    public void tagSoundStreamBlock(byte[] soundData) throws IOException {
        this.println("sound-stream-block");
        if (this.dumpHex) {
            Hex.dump(this.writer, soundData, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagSerialNumber(String serialNumber) throws IOException {
        this.println("serial number =" + serialNumber);
    }

    @Override
    public void tagGenerator(byte[] data) throws IOException {
        this.println("generator tag");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagGeneratorText(byte[] data) throws IOException {
        this.println("generator text");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagGeneratorFont(byte[] data) throws IOException {
        this.println("generator font");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagGeneratorCommand(byte[] data) throws IOException {
        this.println("generator command");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagNameCharacter(byte[] data) throws IOException {
        this.println("generator name character");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagDefineBits(int id, byte[] imageData) throws IOException {
        this.println("jpeg bits");
        if (this.dumpHex) {
            Hex.dump(this.writer, imageData, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
        this.println("jpeg encoding data");
        if (this.dumpHex) {
            Hex.dump(this.writer, jpegEncodingData, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData) throws IOException {
        this.println("jpeg with alpha");
        if (this.dumpHex) {
            Hex.dump(this.writer, imageData, 0L, this.indent + "    ", false);
            this.println("--- Alpha Channel follows ---");
            Hex.dump(this.writer, alphaData, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagDefineSound(int id, int format, int frequency, boolean bits16, boolean stereo, int sampleCount, byte[] soundData) throws IOException {
        String freq = "5.5";
        if (frequency == 1) {
            freq = "11";
        }
        if (frequency == 2) {
            freq = "22";
        }
        if (frequency == 3) {
            freq = "44";
        }
        String formatS = "RawSamples";
        if (format == 1) {
            formatS = "ADPCM";
        }
        if (format == 2) {
            formatS = "MP3";
        }
        this.println("define sound: id=" + id + " format=" + formatS + " freq=" + freq + "kHz 16bit=" + bits16 + " stereo=" + stereo + " samples=" + sampleCount);
        if (this.dumpHex) {
            Hex.dump(this.writer, soundData, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagDefineButtonSound(int buttonId, int rollOverSoundId, SoundInfo rollOverSoundInfo, int rollOutSoundId, SoundInfo rollOutSoundInfo, int pressSoundId, SoundInfo pressSoundInfo, int releaseSoundId, SoundInfo releaseSoundInfo) throws IOException {
        this.println("define button sound: id=" + buttonId);
        this.println("    roll-over sound=" + rollOverSoundId + " " + rollOverSoundInfo);
        this.println("    roll-out  sound=" + rollOutSoundId + " " + rollOutSoundInfo);
        this.println("    press     sound=" + pressSoundId + " " + pressSoundInfo);
        this.println("    release   sound=" + releaseSoundId + " " + releaseSoundInfo);
    }

    @Override
    public void tagShowFrame() throws IOException {
        this.println("---------- frame ----------");
    }

    @Override
    public SWFActions tagDoAction() throws IOException {
        this.println("actions:");
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    @Override
    public SWFActions tagDoInitAction(int spriteId) throws IOException {
        this.println("init actions for sprite " + spriteId + ":");
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    @Override
    public SWFShape tagDefineShape(int id, Rect outline) throws IOException {
        this.println("shape id=" + id + "   " + outline);
        return this;
    }

    @Override
    public SWFShape tagDefineShape2(int id, Rect outline) throws IOException {
        this.println("shape2 id=" + id + "   " + outline);
        return this;
    }

    @Override
    public SWFShape tagDefineShape3(int id, Rect outline) throws IOException {
        this.println("shape3 id=" + id + "   " + outline);
        return this;
    }

    @Override
    public void tagFreeCharacter(int charId) throws IOException {
        this.println("free character id=" + charId);
    }

    @Override
    public void tagPlaceObject(int charId, int depth, Matrix matrix, AlphaTransform cxform) throws IOException {
        this.println("place-object id=" + charId + " depth=" + depth + "  " + matrix + "  " + cxform);
    }

    @Override
    public SWFActions tagPlaceObject2(boolean isMove, int clipDepth, int depth, int charId, Matrix matrix, AlphaTransform cxform, int ratio, String name, int clipActionFlags) throws IOException {
        this.println("place-object2 move=" + isMove + " id=" + charId + " depth=" + depth + " clip=" + clipDepth + " ratio=" + ratio + " name=" + name + "  " + matrix + "  " + cxform);
        if (clipActionFlags != 0) {
            this.println("  clip-actions:");
            ActionTextWriter acts = new ActionTextWriter(this.writer);
            acts.indent = "    " + this.indent;
            return acts;
        }
        return null;
    }

    @Override
    public void tagRemoveObject(int charId, int depth) throws IOException {
        this.println("remove-object id=" + charId + " depth=" + depth);
    }

    @Override
    public void tagRemoveObject2(int depth) throws IOException {
        this.println("remove-object2 depth=" + depth);
    }

    @Override
    public void tagSetBackgroundColor(Color color) throws IOException {
        this.println("background-color  " + color);
    }

    @Override
    public void tagFrameLabel(String label) throws IOException {
        this.println("frame-label " + label);
    }

    @Override
    public void tagFrameLabel(String label, boolean isAnchor) throws IOException {
        this.println("frame-label " + label + (isAnchor ? " (anchor)" : ""));
    }

    @Override
    public SWFTagTypes tagDefineSprite(int id) throws IOException {
        this.println("sprite id=" + id);
        SWFTagDumper dumper = new SWFTagDumper(this.writer, this.dumpHex, this.decompileActions);
        dumper.indent = this.indent + "    ";
        return dumper;
    }

    @Override
    public void tagProtect(byte[] password) throws IOException {
        this.println("protect");
    }

    @Override
    public void tagEnableDebug(byte[] password) throws IOException {
        this.println("enable-debug");
    }

    @Override
    public void tagEnableDebug2(byte[] password) throws IOException {
        this.println("enable-debug-2");
    }

    @Override
    public SWFVectors tagDefineFont(int id, int numGlyphs) throws IOException {
        this.println("font id=" + id);
        return this;
    }

    @Override
    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        this.println("font-info id=" + fontId + " name=" + fontName + " flags=" + Integer.toBinaryString(flags) + " codes=" + codes.length);
    }

    @Override
    public void tagDefineFontInfo2(int fontId, String fontName, int flags, int[] codes, int languageCode) throws IOException {
        this.println("font-info2 id=" + fontId + " name=" + fontName + " flags=" + Integer.toBinaryString(flags) + " codes=" + codes.length + " language=" + languageCode);
    }

    @Override
    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        this.println("font2 id=" + id + " flags=" + Integer.toBinaryString(flags) + " name=" + name + " ascent=" + ascent + " descent=" + descent + " leading=" + leading + " has-kerns=" + (kernCodes1 != null));
        return this;
    }

    @Override
    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        if (initialText != null) {
            initialText = initialText.replace('\r', ' ');
            initialText = initialText.replace('\n', ' ');
            initialText = initialText.replace('\b', ' ');
        }
        this.println("edit-field id=" + fieldId + " name=" + fieldName + " text=" + initialText + " font=" + fontId + " size=" + fontSize + " chars=" + charLimit + " left=" + leftMargin + " right=" + rightMargin + " indent=" + indentation + " spacing=" + lineSpacing + " alignment=" + alignment + " flags=" + Integer.toBinaryString(flags) + " " + textColor);
    }

    @Override
    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        this.println("text id=" + id + " " + bounds + " " + matrix);
        return this;
    }

    @Override
    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        this.println("text2 id=" + id + " " + bounds + " " + matrix);
        return this;
    }

    @Override
    public SWFActions tagDefineButton(int id, Vector buttonRecords) throws IOException {
        this.println("button id=" + id);
        Enumeration enum_ = buttonRecords.elements();
        while (enum_.hasMoreElements()) {
            ButtonRecord rec = (ButtonRecord)enum_.nextElement();
            this.println("  " + rec);
        }
        this.println("  actions:");
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    @Override
    public void tagButtonCXForm(int buttonId, ColorTransform transform) throws IOException {
        this.println("button-cxform id=" + buttonId + "  " + transform);
    }

    @Override
    public SWFActions tagDefineButton2(int id, boolean trackAsMenu, Vector buttonRecord2s) throws IOException {
        this.println("button2 id=" + id + " track-as-menu=" + trackAsMenu);
        Enumeration enum_ = buttonRecord2s.elements();
        while (enum_.hasMoreElements()) {
            ButtonRecord2 rec = (ButtonRecord2)enum_.nextElement();
            this.println("  " + rec);
        }
        this.println("  actions:");
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    " + this.indent;
        return acts;
    }

    @Override
    public void tagExport(String[] names, int[] ids) throws IOException {
        this.println("export");
        for (int i = 0; i < names.length && i < ids.length; ++i) {
            this.println("  id=" + ids[i] + " name=" + names[i]);
        }
    }

    @Override
    public void tagImport(String movieName, String[] names, int[] ids) throws IOException {
        this.println("import library-movie=" + movieName);
        for (int i = 0; i < names.length && i < ids.length; ++i) {
            this.println("  id=" + ids[i] + " name=" + names[i]);
        }
    }

    @Override
    public void tagDefineQuickTimeMovie(int id, String filename) throws IOException {
        this.println("quicktime-movie id=" + id + " name=" + filename);
    }

    @Override
    public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
        this.println("jpeg2 id=" + id);
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void tagDefineBitsJPEG2(int id, InputStream jpegImage) throws IOException {
        this.println("jpeg2 id=" + id + " (from input stream)");
    }

    @Override
    public SWFShape tagDefineMorphShape(int id, Rect startBounds, Rect endBounds) throws IOException {
        this.println("morph-shape id=" + id + " start: " + startBounds + "  end: " + endBounds);
        return this;
    }

    @Override
    public void tagDefineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.dumpBitsLossless("bits-lossless", id, format, width, height, colors, imageData);
    }

    @Override
    public void tagDefineBitsLossless2(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.dumpBitsLossless("bits-lossless2", id, format, width, height, colors, imageData);
    }

    public void dumpBitsLossless(String name, int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        int size = 0;
        if (format == 3) {
            size = 8;
        } else if (format == 4) {
            size = 16;
        } else if (format == 5) {
            size = 32;
        }
        this.println(name + " id=" + id + " bits=" + size + " width=" + width + " height=" + height);
        if (this.dumpHex) {
            for (int i = 0; i < colors.length; ++i) {
                this.println("    " + i + ": " + colors[i]);
            }
            Hex.dump(this.writer, imageData, 0L, this.indent + "    ", false);
            this.println(this.dashes);
        }
    }

    @Override
    public void done() throws IOException {
        this.println("    " + this.dashes);
    }

    @Override
    public void line(int dx, int dy) throws IOException {
        this.println("    line  " + dx + "," + dy);
    }

    @Override
    public void curve(int cx, int cy, int dx, int dy) throws IOException {
        this.println("    curve " + cx + "," + cy + " - " + dx + "," + dy);
    }

    @Override
    public void move(int x, int y) throws IOException {
        this.println("    move  " + x + "," + y);
    }

    @Override
    public void setFillStyle0(int styleIndex) throws IOException {
        this.println("    fill0 = " + styleIndex);
    }

    @Override
    public void setFillStyle1(int styleIndex) throws IOException {
        this.println("    fill1 = " + styleIndex);
    }

    @Override
    public void setLineStyle(int styleIndex) throws IOException {
        this.println("    line  = " + styleIndex);
    }

    @Override
    public void defineFillStyle(Color color) throws IOException {
        this.println("    fill " + color);
    }

    @Override
    public void defineFillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) throws IOException {
        this.println("    fill radial=" + radial + "  " + matrix);
        for (int i = 0; i < ratios.length && i < colors.length; ++i) {
            if (colors[i] == null) continue;
            this.println("         ratio=" + ratios[i] + " " + colors[i]);
        }
    }

    @Override
    public void defineFillStyle(int bitmapId, Matrix matrix, boolean clipped) throws IOException {
        this.println("    fill clipped=" + clipped + " image=" + bitmapId + " " + matrix);
    }

    @Override
    public void defineLineStyle(int width, Color color) throws IOException {
        this.println("    line-style width=" + width + "  " + color);
    }

    @Override
    public void font(int fontId, int textHeight) throws IOException {
        this.println("    font id=" + fontId + " size=" + textHeight);
    }

    @Override
    public void color(Color color) throws IOException {
        this.println("    color " + color);
    }

    @Override
    public void setX(int x) throws IOException {
        this.println("    x = " + x);
    }

    @Override
    public void setY(int y) throws IOException {
        this.println("    y = " + y);
    }

    @Override
    public void text(int[] glyphIndices, int[] glyphAdvances) throws IOException {
        StringBuffer buff1 = new StringBuffer();
        StringBuffer buff2 = new StringBuffer();
        buff1.append("(");
        buff2.append("(");
        for (int i = 0; i < glyphIndices.length && i < glyphAdvances.length; ++i) {
            buff1.append(" ");
            buff2.append(" ");
            buff1.append(glyphIndices[i]);
            buff2.append(glyphAdvances[i]);
        }
        buff1.append(" )");
        buff2.append(" )");
        this.println("    text");
        this.println("        glyph indices = " + buff1);
        this.println("        advances      = " + buff2);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        SWFTagDumper dumper = new SWFTagDumper(args.length > 1, args.length > 2);
        FileInputStream in = new FileInputStream(args[0]);
        TagParser tagparser = new TagParser(dumper);
        SWFReader reader = new SWFReader((SWFTags)tagparser, in);
        try {
            reader.readFile();
        }
        finally {
            dumper.flush();
            in.close();
        }
    }
}

