/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFConstants;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.FillStyle;
import com.anotherbigidea.flash.structs.LineStyle;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.structs.Style;
import com.anotherbigidea.flash.writers.ActionWriter;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class TagWriter
implements SWFTagTypes,
SWFConstants,
SWFFileSignature {
    protected SWFTags mTags;
    protected OutStream out;
    protected ByteArrayOutputStream bytes;
    protected int tagType;
    protected boolean longTag;
    protected int version;
    protected String mStringEncoding = "UTF-8";

    public TagWriter(SWFTags tags) {
        this.mTags = tags;
    }

    protected OutStream getOutStream() {
        return this.out;
    }

    protected SWFActions factorySWFActions() {
        return new ActionWriter(this, this.version);
    }

    protected SWFShape factorySWFShape(boolean hasAlpha, boolean hasStyle) {
        return new SWFShapeImpl(this, hasAlpha, hasStyle);
    }

    @Override
    public void signature(String sig) {
        if (this.mTags instanceof SWFFileSignature) {
            ((SWFFileSignature)((Object)this.mTags)).signature(sig);
        }
    }

    protected void startTag(int tagType, boolean longTag) {
        this.tagType = tagType;
        this.longTag = longTag;
        this.bytes = new ByteArrayOutputStream(10000);
        this.out = new OutStream(this.bytes);
    }

    protected void startTag(int tagType, int id, boolean longTag) throws IOException {
        this.startTag(tagType, longTag);
        this.out.writeUI16(id);
    }

    protected void completeTag() throws IOException {
        this.out.flush();
        byte[] contents = this.bytes.toByteArray();
        this.out = null;
        this.bytes = null;
        this.mTags.tag(this.tagType, this.longTag, contents);
    }

    @Override
    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        this.mTags.tag(tagType, longTag, contents);
    }

    @Override
    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.version = version;
        this.mTags.header(version, -1L, twipsWidth, twipsHeight, frameRate, frameCount);
        if (version < 6) {
            this.mStringEncoding = "US-ASCII";
        }
    }

    @Override
    public void tagEnd() throws IOException {
        this.mTags.tag(0, false, null);
    }

    @Override
    public void tagShowFrame() throws IOException {
        this.mTags.tag(1, false, null);
    }

    @Override
    public void tagDefineSound(int id, int format, int frequency, boolean bits16, boolean stereo, int sampleCount, byte[] soundData) throws IOException {
        this.startTag(14, id, true);
        this.out.writeUBits(4, format);
        this.out.writeUBits(2, frequency);
        this.out.writeUBits(1, bits16 ? 1L : 0L);
        this.out.writeUBits(1, stereo ? 1L : 0L);
        this.out.writeUI32(sampleCount);
        this.out.write(soundData);
        this.completeTag();
    }

    @Override
    public void tagDefineButtonSound(int buttonId, int rollOverSoundId, SoundInfo rollOverSoundInfo, int rollOutSoundId, SoundInfo rollOutSoundInfo, int pressSoundId, SoundInfo pressSoundInfo, int releaseSoundId, SoundInfo releaseSoundInfo) throws IOException {
        this.startTag(17, buttonId, true);
        this.out.writeUI16(rollOverSoundId);
        if (rollOverSoundId != 0) {
            rollOverSoundInfo.write(this.out);
        }
        this.out.writeUI16(rollOutSoundId);
        if (rollOutSoundId != 0) {
            rollOutSoundInfo.write(this.out);
        }
        this.out.writeUI16(pressSoundId);
        if (pressSoundId != 0) {
            pressSoundInfo.write(this.out);
        }
        this.out.writeUI16(releaseSoundId);
        if (releaseSoundId != 0) {
            releaseSoundInfo.write(this.out);
        }
        this.completeTag();
    }

    @Override
    public void tagStartSound(int soundId, SoundInfo info) throws IOException {
        this.startTag(15, soundId, false);
        info.write(this.out);
        this.completeTag();
    }

    @Override
    public void tagSoundStreamHead(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.writeSoundStreamHead(18, playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    @Override
    public void tagSoundStreamHead2(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.writeSoundStreamHead(45, playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void writeSoundStreamHead(int tag, int playbackFrequency, boolean playback16bits, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bits, boolean streamStereo, int averageSampleCount) throws IOException {
        this.startTag(tag, false);
        this.out.writeUBits(4, 0L);
        this.out.writeUBits(2, playbackFrequency);
        this.out.writeUBits(1, playback16bits ? 1L : 0L);
        this.out.writeUBits(1, playbackStereo ? 1L : 0L);
        this.out.writeUBits(4, streamFormat);
        this.out.writeUBits(2, streamFrequency);
        this.out.writeUBits(1, stream16bits ? 1L : 0L);
        this.out.writeUBits(1, streamStereo ? 1L : 0L);
        this.out.writeUI16(averageSampleCount);
        if (streamFormat == 2) {
            this.out.writeUI16(0);
        }
        this.completeTag();
    }

    @Override
    public void tagSoundStreamBlock(byte[] soundData) throws IOException {
        this.startTag(19, true);
        this.out.write(soundData);
        this.completeTag();
    }

    @Override
    public void tagSerialNumber(String serialNumber) throws IOException {
        this.startTag(41, false);
        this.out.writeString(serialNumber, this.mStringEncoding);
        this.completeTag();
    }

    @Override
    public void tagGenerator(byte[] data) throws IOException {
        this.startTag(51, false);
        this.out.write(data);
        this.completeTag();
    }

    @Override
    public void tagGeneratorText(byte[] data) throws IOException {
        this.startTag(42, false);
        this.out.write(data);
        this.completeTag();
    }

    @Override
    public void tagGeneratorCommand(byte[] data) throws IOException {
        this.startTag(49, false);
        this.out.write(data);
        this.completeTag();
    }

    @Override
    public void tagGeneratorFont(byte[] data) throws IOException {
        this.startTag(52, false);
        this.out.write(data);
        this.completeTag();
    }

    @Override
    public void tagNameCharacter(byte[] data) throws IOException {
        this.startTag(40, false);
        this.out.write(data);
        this.completeTag();
    }

    @Override
    public void tagDefineBits(int id, byte[] imageData) throws IOException {
        this.startTag(6, id, true);
        this.out.write(imageData);
        this.completeTag();
    }

    @Override
    public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
        this.startTag(8, true);
        this.out.write(jpegEncodingData);
        this.completeTag();
    }

    @Override
    public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData) throws IOException {
        this.startTag(35, id, true);
        this.out.writeUI32(imageData.length);
        this.out.write(imageData);
        this.out.write(alphaData);
        this.completeTag();
    }

    @Override
    public SWFActions tagDoAction() throws IOException {
        this.startTag(12, true);
        return this.factorySWFActions();
    }

    @Override
    public SWFActions tagDoInitAction(int spriteId) throws IOException {
        this.startTag(59, spriteId, true);
        return this.factorySWFActions();
    }

    @Override
    public SWFShape tagDefineShape(int id, Rect outline) throws IOException {
        this.startShape(2, id, outline);
        return this.factorySWFShape(false, true);
    }

    @Override
    public SWFShape tagDefineShape2(int id, Rect outline) throws IOException {
        this.startShape(22, id, outline);
        return this.factorySWFShape(false, true);
    }

    @Override
    public SWFShape tagDefineShape3(int id, Rect outline) throws IOException {
        this.startShape(32, id, outline);
        return this.factorySWFShape(true, true);
    }

    @Override
    public void tagFreeCharacter(int charId) throws IOException {
        this.startTag(3, false);
        this.out.writeUI16(charId);
        this.completeTag();
    }

    @Override
    public void tagPlaceObject(int charId, int depth, Matrix matrix, AlphaTransform cxform) throws IOException {
        this.startTag(4, false);
        this.out.writeUI16(charId);
        this.out.writeUI16(depth);
        matrix.write(this.out);
        if (cxform != null) {
            cxform.write(this.out);
        }
        this.completeTag();
    }

    @Override
    public SWFActions tagPlaceObject2(boolean isMove, int clipDepth, int depth, int charId, Matrix matrix, AlphaTransform cxform, int ratio, String name, int clipActionFlags) throws IOException {
        boolean hasClipActions = clipActionFlags != 0;
        this.startTag(26, false);
        this.out.writeUBits(1, hasClipActions ? 1L : 0L);
        this.out.writeUBits(1, clipDepth > 0 ? 1L : 0L);
        this.out.writeUBits(1, name != null ? 1L : 0L);
        this.out.writeUBits(1, ratio >= 0 ? 1L : 0L);
        this.out.writeUBits(1, cxform != null ? 1L : 0L);
        this.out.writeUBits(1, matrix != null ? 1L : 0L);
        this.out.writeUBits(1, charId > 0 ? 1L : 0L);
        this.out.writeUBits(1, isMove ? 1L : 0L);
        this.out.writeUI16(depth);
        if (charId > 0) {
            this.out.writeUI16(charId);
        }
        if (matrix != null) {
            matrix.write(this.out);
        }
        if (cxform != null) {
            cxform.write(this.out);
        }
        if (ratio >= 0) {
            this.out.writeUI16(ratio);
        }
        if (clipDepth > 0) {
            this.out.writeUI16(clipDepth);
        }
        if (name != null) {
            this.out.writeString(name, this.mStringEncoding);
            this.longTag = true;
        }
        if (hasClipActions) {
            this.out.writeUI16(0);
            this.out.writeUI16(clipActionFlags);
            return new ActionWriter(this, this.version){

                @Override
                public void start(int conditions) throws IOException {
                    super.start(conditions);
                    this.tagWriter.out.writeUI16(conditions);
                }

                @Override
                protected void writeBytes(byte[] bytes) throws IOException {
                    this.tagWriter.out.writeUI32(bytes.length);
                    super.writeBytes(bytes);
                }

                @Override
                public void done() throws IOException {
                    this.tagWriter.out.writeUI16(0);
                    super.done();
                }
            };
        }
        this.completeTag();
        return null;
    }

    @Override
    public void tagRemoveObject(int charId, int depth) throws IOException {
        this.startTag(5, false);
        this.out.writeUI16(charId);
        this.out.writeUI16(depth);
        this.completeTag();
    }

    @Override
    public void tagRemoveObject2(int depth) throws IOException {
        this.startTag(28, false);
        this.out.writeUI16(depth);
        this.completeTag();
    }

    @Override
    public void tagSetBackgroundColor(Color color) throws IOException {
        this.startTag(9, false);
        color.writeRGB(this.out);
        this.completeTag();
    }

    @Override
    public void tagFrameLabel(String label) throws IOException {
        this.tagFrameLabel(label, false);
    }

    @Override
    public void tagFrameLabel(String label, boolean isAnchor) throws IOException {
        this.startTag(43, true);
        this.out.writeString(label, this.mStringEncoding);
        if (isAnchor) {
            this.out.writeUI8(1);
        }
        this.completeTag();
    }

    @Override
    public SWFTagTypes tagDefineSprite(int id) throws IOException {
        this.startTag(39, id, true);
        this.out.writeUI16(0);
        TagWriter writer = new TagWriter(new SpriteTags());
        writer.version = this.version;
        return writer;
    }

    @Override
    public void tagProtect(byte[] password) throws IOException {
        this.mTags.tag(24, false, password);
    }

    @Override
    public void tagEnableDebug(byte[] password) throws IOException {
        this.mTags.tag(58, false, password);
    }

    @Override
    public void tagEnableDebug2(byte[] password) throws IOException {
        this.startTag(64, 0, false);
        this.out.write(password);
        this.completeTag();
    }

    @Override
    public SWFVectors tagDefineFont(int id, int numGlyphs) throws IOException {
        this.startTag(10, id, true);
        return new SWFShapeImpl(this, numGlyphs);
    }

    @Override
    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        this.startTag(13, true);
        this.out.writeUI16(fontId);
        byte[] chars = fontName.getBytes();
        this.out.writeUI8(chars.length);
        this.out.write(chars);
        this.out.writeUI8(flags);
        boolean wide = (flags & 1) != 0;
        for (int i = 0; i < codes.length; ++i) {
            if (wide) {
                this.out.writeUI16(codes[i]);
                continue;
            }
            this.out.writeUI8(codes[i]);
        }
        this.completeTag();
    }

    @Override
    public void tagDefineFontInfo2(int fontId, String fontName, int flags, int[] codes, int languageCode) throws IOException {
        this.startTag(62, true);
        this.out.writeUI16(fontId);
        byte[] chars = fontName.getBytes();
        this.out.writeUI8(chars.length);
        this.out.write(chars);
        this.out.writeUI8(flags |= 1);
        this.out.writeUI8(languageCode);
        for (int i = 0; i < codes.length; ++i) {
            this.out.writeUI16(codes[i]);
        }
        this.completeTag();
    }

    @Override
    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        this.startTag(48, id, true);
        this.out.writeUI8(flags);
        this.out.writeUI8(0);
        byte[] nameBytes = name.getBytes();
        this.out.writeUI8(nameBytes.length);
        this.out.write(nameBytes);
        this.out.writeUI16(numGlyphs);
        return new Font2ShapeImpl(this, flags, numGlyphs, ascent, descent, leading, codes, advances, bounds, kernCodes1, kernCodes2, kernAdjustments);
    }

    @Override
    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        this.startTag(37, fieldId, true);
        boundary.write(this.out);
        this.out.writeUI16(flags |= 0x2005);
        this.out.writeUI16(fontId);
        this.out.writeUI16(fontSize);
        textColor.write(this.out);
        if ((flags & 2) != 0) {
            this.out.writeUI16(charLimit);
        }
        this.out.writeUI8(alignment);
        this.out.writeUI16(leftMargin);
        this.out.writeUI16(rightMargin);
        this.out.writeUI16(indentation);
        this.out.writeUI16(lineSpacing);
        this.out.writeString(fieldName, this.mStringEncoding);
        if ((flags & 0x80) != 0) {
            this.out.writeString(initialText, this.mStringEncoding);
        }
        this.completeTag();
    }

    @Override
    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        this.startTag(11, id, true);
        return this.defineText(bounds, matrix, false);
    }

    @Override
    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        this.startTag(33, id, true);
        return this.defineText(bounds, matrix, true);
    }

    @Override
    public SWFActions tagDefineButton(int id, Vector buttonRecords) throws IOException {
        this.startTag(7, id, true);
        ButtonRecord.write(this.out, buttonRecords);
        System.out.println("BUTTON");
        return new ActionWriter(this, this.version);
    }

    @Override
    public void tagButtonCXForm(int buttonId, ColorTransform transform) throws IOException {
        this.startTag(23, buttonId, false);
        transform.writeWithoutAlpha(this.out);
        this.completeTag();
    }

    @Override
    public SWFActions tagDefineButton2(int id, boolean trackAsMenu, Vector buttonRecord2s) throws IOException {
        this.startTag(34, id, true);
        this.out.writeUI8(trackAsMenu ? 1 : 0);
        return new ButtonActionWriter(this, this.version, buttonRecord2s);
    }

    @Override
    public void tagExport(String[] names, int[] ids) throws IOException {
        this.startTag(56, true);
        int count = ids.length;
        this.out.writeUI16(count);
        for (int i = 0; i < count; ++i) {
            this.out.writeUI16(ids[i]);
            this.out.writeString(names[i], this.mStringEncoding);
        }
        this.completeTag();
    }

    @Override
    public void tagImport(String movieName, String[] names, int[] ids) throws IOException {
        this.startTag(57, true);
        int count = ids.length;
        this.out.writeString(movieName, this.mStringEncoding);
        this.out.writeUI16(count);
        for (int i = 0; i < count; ++i) {
            this.out.writeUI16(ids[i]);
            this.out.writeString(names[i], this.mStringEncoding);
        }
        this.completeTag();
    }

    @Override
    public void tagDefineQuickTimeMovie(int id, String filename) throws IOException {
        this.startTag(38, id, true);
        this.out.writeString(filename, this.mStringEncoding);
        this.completeTag();
    }

    @Override
    public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
        this.startTag(21, id, true);
        this.out.write(data);
        this.completeTag();
    }

    @Override
    public void tagDefineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.writeBitsLossless(id, format, width, height, colors, imageData, false);
    }

    @Override
    public void tagDefineBitsLossless2(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.writeBitsLossless(id, format, width, height, colors, imageData, true);
    }

    public void writeBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData, boolean hasAlpha) throws IOException {
        this.startTag(hasAlpha ? 36 : 20, id, true);
        this.out.writeUI8(format);
        this.out.writeUI16(width);
        this.out.writeUI16(height);
        switch (format) {
            case 3: {
                this.out.writeUI8(colors.length - 1);
                break;
            }
            case 4: {
                this.out.writeUI16(colors.length - 1);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IOException("unknown bitmap format: " + format);
            }
        }
        DeflaterOutputStream deflater = new DeflaterOutputStream(this.bytes);
        OutStream zipOut = new OutStream(deflater);
        if (format == 3 || format == 4) {
            for (int i = 0; i < colors.length; ++i) {
                if (hasAlpha) {
                    colors[i].writeWithAlpha(zipOut);
                    continue;
                }
                colors[i].writeRGB(zipOut);
            }
        }
        zipOut.write(imageData);
        zipOut.flush();
        deflater.finish();
        this.completeTag();
    }

    @Override
    public void tagDefineBitsJPEG2(int id, InputStream jpegImage) throws IOException {
        this.startTag(21, id, true);
        this.out.writeUI8(255);
        this.out.writeUI8(217);
        this.out.writeUI8(255);
        this.out.writeUI8(216);
        int read = 0;
        byte[] bytes = new byte[10000];
        while ((read = jpegImage.read(bytes)) >= 0) {
            this.out.write(bytes, 0, read);
        }
        jpegImage.close();
        this.completeTag();
    }

    @Override
    public SWFShape tagDefineMorphShape(int id, Rect startBounds, Rect endBounds) throws IOException {
        this.startTag(46, id, true);
        startBounds.write(this.out);
        endBounds.write(this.out);
        return new MorphShapeImpl(this);
    }

    protected SWFText defineText(Rect bounds, Matrix matrix, boolean hasAlpha) throws IOException {
        bounds.write(this.out);
        matrix.write(this.out);
        return new SWFTextImpl(hasAlpha);
    }

    protected void startShape(int tagType, int id, Rect outline) throws IOException {
        this.startTag(tagType, id, true);
        outline.write(this.out);
    }

    protected static class Font2ShapeImpl
    extends SWFShapeImpl {
        protected int flags;
        protected int ascent;
        protected int descent;
        protected int leading;
        protected int[] codes;
        protected int[] advances;
        protected Rect[] bounds;
        protected int[] kernCodes1;
        protected int[] kernCodes2;
        protected int[] kernAdjustments;

        public Font2ShapeImpl(TagWriter writer, int flags, int glyphCount, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) {
            super(writer, glyphCount);
            this.flags = flags;
            this.ascent = ascent;
            this.descent = descent;
            this.leading = leading;
            this.codes = codes;
            this.advances = advances;
            this.bounds = bounds;
            this.kernCodes1 = kernCodes1;
            this.kernCodes2 = kernCodes2;
            this.kernAdjustments = kernAdjustments;
        }

        @Override
        protected void finishFont() throws IOException {
            int i;
            int i2;
            this.out = this.writer.getOutStream();
            int glyphCount = this.glyphByteArrays.size();
            boolean is32 = (this.flags & 8) != 0;
            int offset = is32 ? (glyphCount + 1) * 4 : (glyphCount + 1) * 2;
            for (i2 = 0; i2 <= glyphCount; ++i2) {
                if (is32) {
                    this.out.writeUI32(offset);
                } else {
                    this.out.writeUI16(offset);
                }
                if (i2 >= glyphCount) continue;
                offset += ((byte[])this.glyphByteArrays.elementAt(i2)).length;
            }
            for (i2 = 0; i2 < glyphCount; ++i2) {
                this.out.write((byte[])this.glyphByteArrays.elementAt(i2));
            }
            boolean isWide = (this.flags & 4) != 0 || glyphCount > 256;
            for (i = 0; i < glyphCount; ++i) {
                if (isWide) {
                    this.out.writeUI16(this.codes[i]);
                    continue;
                }
                this.out.writeUI8(this.codes[i]);
            }
            if ((this.flags & 0x80) != 0) {
                this.out.writeSI16((short)this.ascent);
                this.out.writeSI16((short)this.descent);
                this.out.writeSI16((short)this.leading);
                for (i = 0; i < glyphCount; ++i) {
                    this.out.writeSI16((short)this.advances[i]);
                }
                for (i = 0; i < glyphCount; ++i) {
                    this.bounds[i].write(this.out);
                }
                int kerningCount = this.kernCodes1 != null ? this.kernCodes1.length : 0;
                this.out.writeUI16(kerningCount);
                for (int i3 = 0; i3 < kerningCount; ++i3) {
                    if (isWide) {
                        this.out.writeUI16(this.kernCodes1[i3]);
                        this.out.writeUI16(this.kernCodes2[i3]);
                        this.out.writeSI16((short)this.kernAdjustments[i3]);
                        continue;
                    }
                    this.out.writeUI8(this.kernCodes1[i3]);
                    this.out.writeUI8(this.kernCodes2[i3]);
                    this.out.writeSI16((short)this.kernAdjustments[i3]);
                }
            }
        }
    }

    protected static class MorphShapeImpl
    extends SWFShapeImpl {
        protected int edgeOffsetBase;
        protected int edgeOffsetTarget;
        protected int shapeCount;
        protected int fillBitSize;
        protected int lineBitSize;
        protected int shapeStart;

        public MorphShapeImpl(TagWriter writer) throws IOException {
            super(writer, true, false);
            this.fill0Index = -1;
            this.fill1Index = -1;
            this.lineIndex = -1;
            this.shapeCount = 2;
            this.out = writer.getOutStream();
            this.edgeOffsetBase = this.out.getCount();
            this.out.writeUI32(0L);
        }

        @Override
        public void done() throws IOException {
            if (!this.initialStyles) {
                this.writeInitialStyles();
                this.initialStyles = true;
            }
            this.out.writeUBits(6, 0L);
            this.out.flushBits();
            if (this.shapeCount == 2) {
                this.edgeOffsetTarget = this.out.getCount();
                this.fill0Index = -1;
                this.fill1Index = -1;
                this.lineIndex = -1;
                this.moveXY = null;
                this.outstandingChanges = true;
                this.initialStyles = false;
                --this.shapeCount;
                return;
            }
            this.out.flush();
            byte[] bytes = this.writer.bytes.toByteArray();
            int edgeOffset = this.edgeOffsetTarget - this.edgeOffsetBase - 4;
            byte[] offsetBytes = OutStream.uintTo4Bytes(edgeOffset);
            bytes[this.edgeOffsetBase] = offsetBytes[0];
            bytes[this.edgeOffsetBase + 1] = offsetBytes[1];
            bytes[this.edgeOffsetBase + 2] = offsetBytes[2];
            bytes[this.edgeOffsetBase + 3] = offsetBytes[3];
            this.writer.out = null;
            this.writer.bytes = null;
            this.writer.mTags.tag(this.writer.tagType, this.writer.longTag, bytes);
        }

        @Override
        protected void writeInitialStyles() throws IOException {
            this.out.flushBits();
            int fillCount = this.fillStyles.size() / 2;
            int lineCount = this.lineStyles.size() / 2;
            this.fillBitSize = OutStream.determineUnsignedBitSize(fillCount);
            this.lineBitSize = OutStream.determineUnsignedBitSize(lineCount);
            if (this.shapeCount == 2) {
                Style endStyle;
                Style startStyle;
                if (fillCount < 255) {
                    this.out.writeUI8(fillCount);
                } else {
                    this.out.writeUI8(255);
                    this.out.writeUI16(fillCount);
                }
                Enumeration enum_ = this.fillStyles.elements();
                while (enum_.hasMoreElements()) {
                    startStyle = (FillStyle)enum_.nextElement();
                    endStyle = (FillStyle)enum_.nextElement();
                    FillStyle.writeMorphFillStyle(this.out, startStyle, endStyle);
                }
                if (lineCount < 255) {
                    this.out.writeUI8(lineCount);
                } else {
                    this.out.writeUI8(255);
                    this.out.writeUI16(lineCount);
                }
                enum_ = this.lineStyles.elements();
                while (enum_.hasMoreElements()) {
                    startStyle = (LineStyle)enum_.nextElement();
                    endStyle = (LineStyle)enum_.nextElement();
                    LineStyle.writeMorphLineStyle(this.out, (LineStyle)startStyle, (LineStyle)endStyle);
                }
            }
            if (this.shapeStart == 0) {
                this.shapeStart = this.out.getCount();
            }
            this.out.writeUBits(4, this.fillBitSize);
            this.out.writeUBits(4, this.lineBitSize);
        }

        @Override
        protected void writeChangeRecord() throws IOException {
            boolean hasLineStyle;
            boolean hasMoveTo = this.moveXY != null;
            boolean hasFillStyle0 = this.fill0Index >= 0;
            boolean hasFillStyle1 = this.fill1Index >= 0;
            boolean bl = hasLineStyle = this.lineIndex >= 0;
            if (hasFillStyle0 || hasFillStyle1 || hasLineStyle || hasMoveTo) {
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, hasLineStyle ? 1L : 0L);
                this.out.writeUBits(1, hasFillStyle1 ? 1L : 0L);
                this.out.writeUBits(1, hasFillStyle0 ? 1L : 0L);
                this.out.writeUBits(1, hasMoveTo ? 1L : 0L);
                if (hasMoveTo) {
                    int moveX = this.moveXY[0];
                    int moveY = this.moveXY[1];
                    int moveBits = OutStream.determineSignedBitSize(moveX);
                    int moveYBits = OutStream.determineSignedBitSize(moveY);
                    if (moveYBits > moveBits) {
                        moveBits = moveYBits;
                    }
                    this.out.writeUBits(5, moveBits);
                    this.out.writeSBits(moveBits, moveX);
                    this.out.writeSBits(moveBits, moveY);
                }
                if (hasFillStyle0) {
                    this.out.writeUBits(this.fillBitSize, this.fill0Index);
                }
                if (hasFillStyle1) {
                    this.out.writeUBits(this.fillBitSize, this.fill1Index);
                }
                if (hasLineStyle) {
                    this.out.writeUBits(this.lineBitSize, this.lineIndex);
                }
                this.moveXY = null;
                this.fill0Index = -1;
                this.fill1Index = -1;
                this.lineIndex = -1;
            }
        }
    }

    protected static class SWFShapeImpl
    implements SWFShape {
        protected boolean hasAlpha;
        protected boolean hasStyle;
        protected boolean outstandingChanges = true;
        protected boolean initialStyles = false;
        protected int fill0Index = -1;
        protected int fill1Index = -1;
        protected int lineIndex = -1;
        protected int[] moveXY;
        protected Vector lineStyles = new Vector();
        protected Vector fillStyles = new Vector();
        protected int fillBits;
        protected int lineBits;
        protected int glyphCount = 0;
        protected Vector glyphByteArrays;
        protected OutStream out;
        protected TagWriter writer;
        protected ByteArrayOutputStream bout;

        public SWFShapeImpl(TagWriter writer, boolean hasAlpha, boolean hasStyle) {
            this.hasAlpha = hasAlpha;
            this.hasStyle = hasStyle;
            this.writer = writer;
            this.out = writer.getOutStream();
        }

        public SWFShapeImpl(TagWriter writer, int glyphCount) {
            this(writer, false, false);
            this.glyphCount = glyphCount;
            this.bout = new ByteArrayOutputStream();
            this.out = new OutStream(this.bout);
            this.glyphByteArrays = new Vector();
            this.fill1Index = 1;
            this.lineIndex = 0;
        }

        @Override
        public void done() throws IOException {
            if (!this.initialStyles) {
                this.writeInitialStyles();
                this.initialStyles = true;
            }
            this.out.writeUBits(6, 0L);
            this.out.flushBits();
            if (this.bout != null && this.glyphCount > 0) {
                byte[] glyphBytes = this.bout.toByteArray();
                this.glyphByteArrays.addElement(glyphBytes);
            }
            if (this.glyphCount > 1) {
                this.bout = new ByteArrayOutputStream();
                this.out = new OutStream(this.bout);
                --this.glyphCount;
                this.fill1Index = 1;
                this.lineIndex = 0;
                this.outstandingChanges = true;
                this.initialStyles = false;
            } else {
                if (this.bout != null) {
                    this.finishFont();
                }
                this.writer.completeTag();
            }
        }

        protected void finishFont() throws IOException {
            int i;
            this.out = this.writer.getOutStream();
            int glyphCount = this.glyphByteArrays.size();
            int offset = glyphCount * 2;
            this.out.writeUI16(offset);
            for (i = 0; i < glyphCount - 1; ++i) {
                this.out.writeUI16(offset += ((byte[])this.glyphByteArrays.elementAt(i)).length);
            }
            for (i = 0; i < glyphCount; ++i) {
                this.out.write((byte[])this.glyphByteArrays.elementAt(i));
            }
        }

        @Override
        public void setFillStyle0(int styleIndex) throws IOException {
            this.fill0Index = styleIndex;
            this.outstandingChanges = true;
        }

        @Override
        public void setFillStyle1(int styleIndex) throws IOException {
            this.fill1Index = styleIndex;
            this.outstandingChanges = true;
        }

        @Override
        public void setLineStyle(int styleIndex) throws IOException {
            this.lineIndex = styleIndex;
            this.outstandingChanges = true;
        }

        @Override
        public void defineFillStyle(Color color) throws IOException {
            this.fillStyles.addElement(new FillStyle(color));
            this.outstandingChanges = true;
        }

        @Override
        public void defineFillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) throws IOException {
            this.fillStyles.addElement(new FillStyle(matrix, ratios, colors, radial));
            this.outstandingChanges = true;
        }

        @Override
        public void defineFillStyle(int bitmapId, Matrix matrix, boolean clipped) throws IOException {
            this.fillStyles.addElement(new FillStyle(bitmapId, matrix, clipped));
            this.outstandingChanges = true;
        }

        @Override
        public void defineLineStyle(int width, Color color) throws IOException {
            this.lineStyles.addElement(new LineStyle(width, color));
            this.outstandingChanges = true;
        }

        @Override
        public void line(int deltaX, int deltaY) throws IOException {
            if (this.outstandingChanges) {
                this.flushChangeRecords();
            }
            int numBits = OutStream.determineSignedBitSize(deltaX);
            int dyBits = OutStream.determineSignedBitSize(deltaY);
            if (dyBits > numBits) {
                numBits = dyBits;
            }
            if (numBits < 2) {
                numBits = 2;
            }
            this.out.writeUBits(2, 3L);
            this.out.writeUBits(4, numBits - 2);
            if (deltaX != 0 && deltaY != 0) {
                this.out.writeUBits(1, 1L);
                this.out.writeSBits(numBits, deltaX);
                this.out.writeSBits(numBits, deltaY);
            } else {
                this.out.writeUBits(1, 0L);
                if (deltaY != 0) {
                    this.out.writeUBits(1, 1L);
                    this.out.writeSBits(numBits, deltaY);
                } else {
                    this.out.writeUBits(1, 0L);
                    this.out.writeSBits(numBits, deltaX);
                }
            }
        }

        @Override
        public void curve(int cx, int cy, int dx, int dy) throws IOException {
            if (this.outstandingChanges) {
                this.flushChangeRecords();
            }
            int numBits = OutStream.determineSignedBitSize(cx);
            int dyBits = OutStream.determineSignedBitSize(cy);
            int adxBits = OutStream.determineSignedBitSize(dx);
            int adyBits = OutStream.determineSignedBitSize(dy);
            if (dyBits > numBits) {
                numBits = dyBits;
            }
            if (adxBits > numBits) {
                numBits = adxBits;
            }
            if (adyBits > numBits) {
                numBits = adyBits;
            }
            if (numBits < 2) {
                numBits = 2;
            }
            this.out.writeUBits(2, 2L);
            this.out.writeUBits(4, numBits - 2);
            this.out.writeSBits(numBits, cx);
            this.out.writeSBits(numBits, cy);
            this.out.writeSBits(numBits, dx);
            this.out.writeSBits(numBits, dy);
        }

        @Override
        public void move(int x, int y) throws IOException {
            this.moveXY = new int[]{x, y};
            this.outstandingChanges = true;
        }

        protected void flushChangeRecords() throws IOException {
            if (!this.initialStyles) {
                this.writeInitialStyles();
                this.initialStyles = true;
            }
            this.writeChangeRecord();
            this.outstandingChanges = false;
        }

        protected void writeInitialStyles() throws IOException {
            this.out.flushBits();
            this.fillBits = OutStream.determineUnsignedBitSize(this.fillStyles.size());
            this.lineBits = OutStream.determineUnsignedBitSize(this.lineStyles.size());
            if (!this.hasStyle) {
                this.fillBits = 1;
            } else {
                this.writeStyles(this.fillStyles);
                this.writeStyles(this.lineStyles);
                this.out.flushBits();
            }
            this.out.writeUBits(4, this.fillBits);
            this.out.writeUBits(4, this.lineBits);
        }

        protected void writeChangeRecord() throws IOException {
            boolean hasLineStyle;
            boolean hasNewStyles = this.hasStyle && (this.fillStyles.size() > 0 || this.lineStyles.size() > 0);
            boolean hasMoveTo = this.moveXY != null;
            boolean hasFillStyle0 = this.fill0Index >= 0;
            boolean hasFillStyle1 = this.fill1Index >= 0;
            boolean bl = hasLineStyle = this.lineIndex >= 0;
            if (!this.hasStyle && hasFillStyle0) {
                hasFillStyle1 = false;
            }
            if (hasNewStyles) {
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.out.writeUBits(1, 1L);
                this.writeMoveXY(0, 0);
                this.out.writeUBits(this.fillBits, 0L);
                this.out.writeUBits(this.fillBits, 0L);
                this.out.writeUBits(this.lineBits, 0L);
                if (this.fill0Index == 0) {
                    this.fill0Index = -1;
                }
                if (this.fill1Index == 0) {
                    this.fill1Index = -1;
                }
                if (this.lineIndex == 0) {
                    this.lineIndex = -1;
                }
                this.fillBits = OutStream.determineUnsignedBitSize(this.fillStyles.size());
                this.lineBits = OutStream.determineUnsignedBitSize(this.lineStyles.size());
                this.writeStyles(this.fillStyles);
                this.writeStyles(this.lineStyles);
                this.out.writeUBits(4, this.fillBits);
                this.out.writeUBits(4, this.lineBits);
                this.writeChangeRecord();
                return;
            }
            if (hasFillStyle0 || hasFillStyle1 || hasLineStyle || hasMoveTo) {
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, 0L);
                this.out.writeUBits(1, hasLineStyle ? 1L : 0L);
                this.out.writeUBits(1, hasFillStyle1 ? 1L : 0L);
                this.out.writeUBits(1, hasFillStyle0 ? 1L : 0L);
                this.out.writeUBits(1, hasMoveTo ? 1L : 0L);
                if (hasMoveTo) {
                    int moveX = this.moveXY[0];
                    int moveY = this.moveXY[1];
                    this.writeMoveXY(moveX, moveY);
                }
                if (hasFillStyle0) {
                    this.out.writeUBits(this.fillBits, this.fill0Index);
                }
                if (hasFillStyle1) {
                    this.out.writeUBits(this.fillBits, this.fill1Index);
                }
                if (hasLineStyle) {
                    this.out.writeUBits(this.lineBits, this.lineIndex);
                }
                this.moveXY = null;
                this.fill0Index = -1;
                this.fill1Index = -1;
                this.lineIndex = -1;
            }
        }

        protected void writeMoveXY(int moveX, int moveY) throws IOException {
            int moveBits = OutStream.determineSignedBitSize(moveX);
            int moveYBits = OutStream.determineSignedBitSize(moveY);
            if (moveYBits > moveBits) {
                moveBits = moveYBits;
            }
            this.out.writeUBits(5, moveBits);
            this.out.writeSBits(moveBits, moveX);
            this.out.writeSBits(moveBits, moveY);
        }

        protected void writeStyles(Vector styles) throws IOException {
            int numStyles;
            int n = numStyles = styles != null ? styles.size() : 0;
            if (numStyles < 255) {
                this.out.writeUI8(numStyles);
            } else {
                this.out.writeUI8(255);
                this.out.writeUI16(numStyles);
            }
            if (styles != null) {
                Enumeration enum_ = styles.elements();
                while (enum_.hasMoreElements()) {
                    Style style = (Style)enum_.nextElement();
                    style.write(this.out, this.hasAlpha);
                }
                styles.removeAllElements();
            }
        }
    }

    protected class SpriteTags
    implements SWFTags {
        protected int frameCount = 0;

        protected SpriteTags() {
        }

        @Override
        public void tag(int tagType2, boolean longTag2, byte[] contents) throws IOException {
            int length = contents != null ? contents.length : 0;
            longTag2 = length > 62 || longTag2;
            int hdr = (tagType2 << 6) + (longTag2 ? 63 : length);
            TagWriter.this.out.writeUI16(hdr);
            if (longTag2) {
                TagWriter.this.out.writeUI32(length);
            }
            if (contents != null) {
                TagWriter.this.out.write(contents);
            }
            if (tagType2 == 1) {
                ++this.frameCount;
            }
            if (tagType2 == 0) {
                TagWriter.this.out.flush();
                contents = TagWriter.this.bytes.toByteArray();
                TagWriter.this.out = null;
                TagWriter.this.bytes = null;
                byte[] fc = OutStream.uintTo2Bytes(this.frameCount);
                contents[2] = fc[0];
                contents[3] = fc[1];
                TagWriter.this.mTags.tag(TagWriter.this.tagType, TagWriter.this.longTag, contents);
            }
        }

        @Override
        public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        }
    }

    protected class SWFTextImpl
    implements SWFText {
        protected boolean hasAlpha;
        protected int maxGlyphIndex = 0;
        protected int maxAdvance = 0;
        protected Vector recs = new Vector();
        protected Object[] currentStyleRecord = null;

        public SWFTextImpl(boolean hasAlpha) {
            this.hasAlpha = hasAlpha;
        }

        protected Object[] getCurrentStyle() {
            if (this.currentStyleRecord == null) {
                this.currentStyleRecord = new Object[4];
                this.recs.addElement(this.currentStyleRecord);
            }
            return this.currentStyleRecord;
        }

        @Override
        public void font(int fontId, int textHeight) throws IOException {
            this.getCurrentStyle()[0] = new int[]{fontId, textHeight};
        }

        @Override
        public void color(Color color) throws IOException {
            this.getCurrentStyle()[3] = color;
        }

        @Override
        public void setX(int x) throws IOException {
            this.getCurrentStyle()[1] = new int[]{x};
        }

        @Override
        public void setY(int y) throws IOException {
            this.getCurrentStyle()[2] = new int[]{y};
        }

        @Override
        public void text(int[] glyphIndices, int[] glyphAdvances) throws IOException {
            this.currentStyleRecord = null;
            this.recs.addElement(new Object[]{glyphIndices, glyphAdvances});
            for (int i = 0; i < glyphIndices.length; ++i) {
                if (glyphIndices[i] > this.maxGlyphIndex) {
                    this.maxGlyphIndex = glyphIndices[i];
                }
                if (glyphAdvances[i] <= this.maxAdvance) continue;
                this.maxAdvance = glyphAdvances[i];
            }
        }

        @Override
        public void done() throws IOException {
            int glyphBits = OutStream.determineUnsignedBitSize(this.maxGlyphIndex);
            int advanceBits = OutStream.determineSignedBitSize(this.maxAdvance);
            TagWriter.this.out.writeUI8(glyphBits);
            TagWriter.this.out.writeUI8(advanceBits);
            Enumeration enum_ = this.recs.elements();
            while (enum_.hasMoreElements()) {
                Object[] rec = (Object[])enum_.nextElement();
                if (rec.length == 4) {
                    boolean hasFont = rec[0] != null;
                    boolean hasX = rec[1] != null;
                    boolean hasY = rec[2] != null;
                    boolean hasColor = rec[3] != null;
                    int flags = 128;
                    if (hasFont) {
                        flags |= 8;
                    }
                    if (hasX) {
                        flags |= 1;
                    }
                    if (hasY) {
                        flags |= 2;
                    }
                    if (hasColor) {
                        flags |= 4;
                    }
                    TagWriter.this.out.writeUI8(flags);
                    if (hasFont) {
                        TagWriter.this.out.writeUI16(((int[])rec[0])[0]);
                    }
                    if (hasColor) {
                        Color color = (Color)rec[3];
                        if (this.hasAlpha) {
                            color.writeWithAlpha(TagWriter.this.out);
                        } else {
                            color.writeRGB(TagWriter.this.out);
                        }
                    }
                    if (hasX) {
                        int xOffset = ((int[])rec[1])[0];
                        TagWriter.this.out.writeSI16((short)xOffset);
                    }
                    if (hasY) {
                        int yOffset = ((int[])rec[2])[0];
                        TagWriter.this.out.writeSI16((short)yOffset);
                    }
                    if (!hasFont) continue;
                    TagWriter.this.out.writeUI16(((int[])rec[0])[1]);
                    continue;
                }
                int[] glyphs = (int[])rec[0];
                int[] advances = (int[])rec[1];
                TagWriter.this.out.writeUI8(glyphs.length);
                for (int i = 0; i < glyphs.length; ++i) {
                    TagWriter.this.out.writeUBits(glyphBits, glyphs[i]);
                    TagWriter.this.out.writeSBits(advanceBits, advances[i]);
                }
            }
            TagWriter.this.out.writeUI8(0);
            TagWriter.this.completeTag();
        }
    }

    protected static class ButtonActionWriter
    extends ActionWriter {
        protected Vector offsets = new Vector();
        protected int lastPtr;
        protected OutStream tagout;

        public ButtonActionWriter(TagWriter tagWriter, int flashVersion, Vector buttonRecs) throws IOException {
            super(tagWriter, flashVersion);
            this.tagout = tagWriter.getOutStream();
            this.lastPtr = this.tagout.getCount();
            this.tagout.writeUI16(0);
            ButtonRecord2.write(this.tagout, buttonRecs);
        }

        @Override
        public void start(int conditions) throws IOException {
            super.start(conditions);
            int ptr = this.tagout.getCount();
            int offset = ptr - this.lastPtr;
            this.offsets.addElement(new int[]{this.lastPtr, offset});
            this.lastPtr = ptr;
            this.tagout.writeUI16(0);
            this.tagout.writeUI16(conditions);
        }

        @Override
        public void done() throws IOException {
            this.offsets.addElement(new int[]{this.lastPtr, 0});
            this.tagout.flush();
            byte[] contents = this.tagWriter.bytes.toByteArray();
            this.tagWriter.out = null;
            this.tagWriter.bytes = null;
            Enumeration enum_ = this.offsets.elements();
            while (enum_.hasMoreElements()) {
                int[] offInfo = (int[])enum_.nextElement();
                int ptr = offInfo[0];
                int off = offInfo[1];
                byte[] offbytes = OutStream.uintTo2Bytes(off);
                contents[ptr] = offbytes[0];
                contents[ptr + 1] = offbytes[1];
            }
            this.tagWriter.mTags.tag(this.tagWriter.tagType, true, contents);
        }
    }
}

