/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;

public class Hex {
    public static String dump(byte[] data, long startAddress, String indent) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter((Writer)writer, true);
        Hex.dump(printer, data, startAddress, indent, false);
        return writer.toString();
    }

    public static String dumpWithBinary(byte[] data, long startAddress, String indent) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter((Writer)writer, true);
        Hex.dump(printer, data, startAddress, indent, true);
        return writer.toString();
    }

    public static void dump(PrintWriter out, byte[] data, long startAddress, String indent, boolean includeBinary) {
        Hex.dump(out, data, 0, data.length, startAddress, indent, includeBinary);
    }

    public static void dump(PrintWriter out, byte[] data, int startIndex, int length, long startAddress, String indent, boolean includeBinary) {
        if (data == null) {
            return;
        }
        int i = startIndex;
        int endIndex = startIndex + length - 1;
        if (endIndex >= data.length) {
            endIndex = data.length - 1;
        }
        while (i <= endIndex) {
            String hex = "";
            String chars = " ";
            String binary = "";
            for (int j = 0; j < 16; ++j) {
                if (i + j <= endIndex) {
                    hex = hex + " " + Hex.leadingZeros(Integer.toHexString(Hex.getByte(data[i + j])), 2);
                    if (includeBinary) {
                        binary = binary + " " + Hex.leadingZeros(Integer.toBinaryString(Hex.getByte(data[i + j])), 8);
                    }
                    if (data[i + j] < 32) {
                        chars = chars + ".";
                        continue;
                    }
                    chars = chars + new String(new byte[]{data[i + j]});
                    continue;
                }
                hex = hex + " --";
                chars = chars + " ";
                if (!includeBinary) continue;
                binary = binary + " --------";
            }
            out.println((indent != null ? indent : "") + Hex.leadingZeros(Long.toHexString(startAddress), 8) + hex + chars + binary);
            i += 16;
            startAddress += 16L;
        }
    }

    public static String leadingZeros(String string, int size) {
        String s = string;
        while (s.length() < size) {
            s = "0" + s;
        }
        return s;
    }

    protected static int getByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile file = new RandomAccessFile(args[0], "r");
        byte[] bytes = new byte[(int)file.length()];
        file.readFully(bytes);
        PrintWriter writer = new PrintWriter(System.out);
        Hex.dump(writer, bytes, 0L, "", false);
        writer.flush();
    }
}

