/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.netpreserve.jwarc.FetchResult;
import org.netpreserve.jwarc.GzipChannel;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCompression;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;

public class WarcWriter
implements Closeable {
    private static final byte[] TRAILER = new byte[]{13, 10, 13, 10};
    private final WritableByteChannel channel;
    private final WarcCompression compression;
    private final ByteBuffer buffer = ByteBuffer.allocate(8192);
    private final String digestAlgorithm = "SHA-1";
    private final AtomicLong position = new AtomicLong(0L);

    public WarcWriter(WritableByteChannel channel, WarcCompression compression) throws IOException {
        this.compression = compression;
        this.channel = compression == WarcCompression.GZIP ? new GzipChannel(channel) : channel;
        if (channel instanceof SeekableByteChannel) {
            this.position.set(((SeekableByteChannel)channel).position());
        }
    }

    public WarcWriter(WritableByteChannel channel) throws IOException {
        this(channel, WarcCompression.NONE);
    }

    public WarcWriter(OutputStream stream) throws IOException {
        this(Channels.newChannel(stream));
    }

    public synchronized void write(WarcRecord record) throws IOException {
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(record.serializeHeader())));
        MessageBody body = record.body();
        while (body.read(this.buffer) >= 0) {
            this.buffer.flip();
            this.position.addAndGet(this.channel.write(this.buffer));
            this.buffer.compact();
        }
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(TRAILER)));
        if (this.compression == WarcCompression.GZIP) {
            ((GzipChannel)this.channel).finish();
            this.position.set(((GzipChannel)this.channel).outputPosition());
        }
    }

    public FetchResult fetch(URI uri) throws IOException {
        HttpRequest httpRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)new HttpRequest.Builder("GET", uri.getRawPath()).version(MessageVersion.HTTP_1_0)).addHeader("Host", uri.getHost())).addHeader("User-Agent", "jwarc")).addHeader("Connection", "close")).build();
        return this.fetch(uri, httpRequest, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FetchResult fetch(URI uri, HttpRequest httpRequest, OutputStream copyTo) throws IOException {
        Path tempPath = Files.createTempFile("jwarc", ".tmp", new FileAttribute[0]);
        try (FileChannel tempFile = FileChannel.open(tempPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.TRUNCATE_EXISTING);){
            InetAddress ip;
            byte[] httpRequestBytes = httpRequest.serializeHeader();
            MessageDigest requestBlockDigest = MessageDigest.getInstance("SHA-1");
            requestBlockDigest.update(httpRequestBytes);
            MessageDigest responseBlockDigest = MessageDigest.getInstance("SHA-1");
            Instant date = Instant.now();
            try (Socket socket = IOUtils.connect(uri.getScheme(), uri.getHost(), uri.getPort());){
                int n;
                socket.setTcpNoDelay(true);
                ip = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress();
                socket.getOutputStream().write(httpRequestBytes);
                InputStream inputStream = socket.getInputStream();
                byte[] buf = new byte[8192];
                while ((n = inputStream.read(buf)) >= 0) {
                    tempFile.write(ByteBuffer.wrap(buf, 0, n));
                    responseBlockDigest.update(buf, 0, n);
                    try {
                        if (copyTo == null) continue;
                        copyTo.write(buf, 0, n);
                    }
                    catch (IOException iOException) {}
                }
            }
            tempFile.position(0L);
            MessageDigest responsePayloadDigest = this.tryCalculatingPayloadDigest(tempFile);
            tempFile.position(0L);
            WarcResponse.Builder responseBuilder = (WarcResponse.Builder)((WarcResponse.Builder)((WarcResponse.Builder)((WarcResponse.Builder)new WarcResponse.Builder(uri).blockDigest(new WarcDigest(responseBlockDigest))).date(date)).body(MediaType.HTTP_RESPONSE, tempFile, tempFile.size())).ipAddress(ip);
            if (responsePayloadDigest != null) {
                responseBuilder.payloadDigest(new WarcDigest(responsePayloadDigest));
            }
            WarcResponse response = responseBuilder.build();
            response.http();
            this.write(response);
            WarcRequest request = ((WarcRequest.Builder)((WarcRequest.Builder)((WarcRequest.Builder)new WarcRequest.Builder(uri).blockDigest(new WarcDigest(requestBlockDigest))).date(date)).body(httpRequest).concurrentTo(response.id())).build();
            request.http();
            this.write(request);
            FetchResult fetchResult = new FetchResult(request, response);
            return fetchResult;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private MessageDigest tryCalculatingPayloadDigest(FileChannel channel) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try {
            int n;
            HttpResponse httpResponse = HttpResponse.parse(channel);
            byte[] buffer = new byte[8192];
            InputStream steam = httpResponse.body().stream();
            long payloadLength = 0L;
            while ((n = steam.read(buffer)) >= 0) {
                digest.update(buffer, 0, n);
                payloadLength += (long)n;
            }
            if (payloadLength == 0L) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return digest;
    }

    public long position() {
        return this.position.get();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

