/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcResponse;

public final class CdxFields {
    static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    public static final byte ORIGINAL_URL = 97;
    public static final byte DATE = 98;
    public static final byte CHECKSUM = 107;
    public static final byte FILENAME = 103;
    public static final byte MIME_TYPE = 109;
    public static final byte REDIRECT = 114;
    public static final byte RESPONSE_CODE = 115;
    public static final byte NORMALIZED_SURT = 78;
    public static final byte COMPRESSED_RECORD_SIZE = 83;
    public static final byte COMPRESSED_ARC_FILE_OFFSET = 86;

    private CdxFields() {
    }

    private static String escape(String str) {
        return str == null ? null : str.replace(" ", "%20");
    }

    public static String format(byte field, WarcCaptureRecord record) {
        try {
            switch (field) {
                case 107: {
                    return record.payloadDigest().map(WarcDigest::base32).orElse("-");
                }
                case 98: {
                    return DATE_FORMAT.format(record.date());
                }
                case 109: {
                    return CdxFields.escape(record.payload().map(p -> p.type().base()).orElse(MediaType.OCTET_STREAM).toString());
                }
                case 97: {
                    return CdxFields.escape(record.target());
                }
                case 78: {
                    return CdxFields.escape(URIs.toNormalizedSurt(record.target()));
                }
                case 114: {
                    if (!(record instanceof WarcResponse)) break;
                    return ((WarcResponse)record).http().headers().first("Location").map(CdxFields::escape).orElse("-");
                }
                case 115: {
                    if (record instanceof WarcResponse) {
                        return Integer.toString(((WarcResponse)record).http().status());
                    }
                    return "200";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "-";
    }
}

