/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MessageBody;

public class LengthedBody
extends MessageBody {
    static final LengthedBody EMPTY = LengthedBody.create(Channels.newChannel(new ByteArrayInputStream(new byte[0])), ByteBuffer.allocate(0), 0L);
    private final ReadableByteChannel channel;
    final ByteBuffer buffer;
    private final long size;
    long position = 0L;
    private boolean open = true;
    ByteBuffer pushback;

    private LengthedBody(ReadableByteChannel channel, ByteBuffer buffer, long size) {
        this.channel = channel;
        this.buffer = buffer;
        this.size = size;
    }

    public static LengthedBody create(ReadableByteChannel channel, ByteBuffer buffer, long size) {
        if (channel instanceof SeekableByteChannel) {
            return new Seekable((SeekableByteChannel)channel, buffer, size);
        }
        return new LengthedBody(channel, buffer, size);
    }

    static LengthedBody createFromContentLength(ReadableByteChannel channel, ByteBuffer buffer, Long contentLengthHeader) throws IOException {
        MessageBody body;
        long size;
        long length = -1L;
        if (channel instanceof LengthedReadableByteChannel) {
            LengthedReadableByteChannel lengthed = (LengthedReadableByteChannel)channel;
            length = lengthed.size() - lengthed.position() + (long)buffer.remaining();
        } else if (channel instanceof LengthedBody) {
            LengthedBody lengthed = (LengthedBody)channel;
            length = lengthed.size() - lengthed.position() + (long)buffer.remaining();
        } else if (channel instanceof SeekableByteChannel) {
            SeekableByteChannel seekable = (SeekableByteChannel)channel;
            length = seekable.size() - seekable.position() + (long)buffer.remaining();
        } else if (channel instanceof MessageBody && (size = (body = (MessageBody)channel).size()) >= 0L) {
            length = body.size() - body.position() + (long)buffer.remaining();
        }
        if (length == -1L) {
            if (contentLengthHeader == null) {
                throw new IllegalArgumentException("unable to determine length");
            }
            length = contentLengthHeader;
        }
        return new LengthedBody(channel, buffer, length);
    }

    synchronized void pushback(byte[] pushback) {
        if ((long)pushback.length > this.position) {
            throw new IllegalArgumentException("pushback would result in negative position");
        }
        if (this.pushback != null) {
            throw new IllegalStateException("already pushed back");
        }
        this.pushback = ByteBuffer.wrap(pushback);
        this.position -= (long)pushback.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer dest) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (this.position >= this.size) {
            return -1;
        }
        if (this.pushback != null) {
            int n = IOUtils.transfer(this.pushback, dest, this.size - this.position);
            if (!this.pushback.hasRemaining()) {
                this.pushback = null;
            }
            this.position += (long)n;
            return n;
        }
        if (this.buffer.hasRemaining()) {
            int n = IOUtils.transfer(this.buffer, dest, this.size - this.position);
            this.position += (long)n;
            return n;
        }
        int savedLimit = dest.limit();
        try {
            dest.limit(dest.position() + (int)Math.min((long)dest.remaining(), this.size - this.position));
            int actuallyRead = this.channel.read(dest);
            if (actuallyRead < 0) {
                throw new EOFException("expected " + (this.size - this.position) + " more bytes in file");
            }
            this.position += (long)actuallyRead;
            int n = actuallyRead;
            return n;
        }
        finally {
            dest.limit(savedLimit);
        }
    }

    @Override
    public synchronized void consume() throws IOException {
        this.discardPushback();
        while (true) {
            long remaining;
            if ((remaining = this.size - this.position) <= (long)this.buffer.remaining()) {
                this.buffer.position(this.buffer.position() + (int)remaining);
                this.position = this.size;
                break;
            }
            if (this.channel instanceof SeekableByteChannel) {
                try {
                    SeekableByteChannel seekable = (SeekableByteChannel)this.channel;
                    seekable.position(seekable.position() + remaining - (long)this.buffer.remaining());
                    this.position = this.size;
                    this.buffer.position(this.buffer.limit());
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.position += (long)this.buffer.remaining();
            this.buffer.clear();
            if (this.channel.read(this.buffer) < 0) {
                throw new EOFException();
            }
            this.buffer.flip();
        }
    }

    void discardPushback() {
        if (this.pushback != null) {
            this.position += (long)this.pushback.remaining();
            this.pushback = null;
        }
    }

    ReadableByteChannel discardPushbackOnRead() {
        return new LengthedReadableByteChannel(){

            @Override
            public int read(ByteBuffer byteBuffer) throws IOException {
                LengthedBody.this.discardPushback();
                return LengthedBody.this.read(byteBuffer);
            }

            @Override
            public boolean isOpen() {
                return LengthedBody.this.isOpen();
            }

            @Override
            public void close() throws IOException {
                LengthedBody.this.close();
            }

            @Override
            public long position() {
                return LengthedBody.this.position;
            }

            @Override
            public long size() {
                return LengthedBody.this.size;
            }
        };
    }

    @Override
    public boolean isOpen() {
        return this.open && this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public InputStream stream() {
        return Channels.newInputStream(this);
    }

    private static class Seekable
    extends LengthedBody
    implements SeekableByteChannel {
        private final SeekableByteChannel seekable;

        Seekable(SeekableByteChannel channel, ByteBuffer buffer, long size) {
            super(channel, buffer, size);
            this.seekable = channel;
        }

        @Override
        public synchronized SeekableByteChannel position(long position) throws IOException {
            if (position < 0L) {
                throw new IllegalArgumentException("negative position");
            }
            long relative = Math.min(this.size(), position) - this.position;
            if (relative >= 0L && relative < (long)this.buffer.remaining() && this.pushback == null) {
                this.buffer.position((int)((long)this.buffer.position() + relative));
            } else {
                this.buffer.position(this.buffer.limit());
                this.seekable.position(this.seekable.position() + relative);
                this.pushback = null;
            }
            this.position += relative;
            return this;
        }

        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            throw new NonWritableChannelException();
        }

        @Override
        public SeekableByteChannel truncate(long l) throws IOException {
            throw new NonWritableChannelException();
        }

        @Override
        SeekableByteChannel discardPushbackOnRead() {
            return new SeekableByteChannel(){

                @Override
                public int read(ByteBuffer byteBuffer) throws IOException {
                    this.discardPushback();
                    return this.read(byteBuffer);
                }

                @Override
                public int write(ByteBuffer byteBuffer) throws IOException {
                    throw new NonWritableChannelException();
                }

                @Override
                public long position() throws IOException {
                    this.discardPushback();
                    return this.position();
                }

                @Override
                public SeekableByteChannel position(long l) throws IOException {
                    this.discardPushback();
                    return this.position(l);
                }

                @Override
                public long size() throws IOException {
                    return this.size();
                }

                @Override
                public SeekableByteChannel truncate(long l) throws IOException {
                    throw new NonWritableChannelException();
                }

                @Override
                public boolean isOpen() {
                    return this.isOpen();
                }

                @Override
                public void close() throws IOException {
                    this.close();
                }
            };
        }
    }

    public static interface LengthedReadableByteChannel
    extends ReadableByteChannel {
        public long position();

        public long size();
    }
}

