/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.ParsingException;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcRevisit;
import org.netpreserve.jwarc.cdx.CdxFormat;
import org.netpreserve.jwarc.cdx.CdxRequestEncoder;

public class CdxWriter
implements Closeable {
    private final Writer writer;
    private CdxFormat format = CdxFormat.CDX11;
    private boolean postAppend = false;
    private Predicate<WarcRecord> recordFilter;
    private Consumer<String> warningHandler;

    public CdxWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeHeaderLine() throws IOException {
        this.writer.write(" CDX ");
        this.writer.write(this.format.legend());
        this.writer.write(10);
    }

    public void write(WarcCaptureRecord capture, String filename, long position, long length) throws IOException {
        this.write(capture, filename, position, length, null);
    }

    public void write(WarcCaptureRecord capture, String filename, long position, long length, String encodedRequest) throws IOException {
        if (this.recordFilter != null && !this.recordFilter.test(capture)) {
            return;
        }
        String urlKey = null;
        if (encodedRequest != null) {
            String rawUrlKey = capture.target() + (capture.target().contains("?") ? (char)'&' : '?') + encodedRequest;
            urlKey = URIs.toNormalizedSurt(rawUrlKey);
        }
        this.writer.write(this.format.format(capture, filename, position, length, urlKey));
        this.writer.write(10);
    }

    public void process(List<Path> warcFiles, boolean useAbsolutePaths) throws IOException {
        for (Path file : warcFiles) {
            WarcReader reader = new WarcReader(file);
            Throwable throwable = null;
            try {
                String filename = (useAbsolutePaths ? file.toAbsolutePath() : file.getFileName()).toString();
                reader.onWarning(message -> this.emitWarning(filename, reader.position(), (String)message));
                this.process(reader, filename);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    public void process(WarcReader reader, String filename) throws IOException {
        WarcRecord record = reader.next().orElse(null);
        while (record != null) {
            try {
                if ((record instanceof WarcResponse || record instanceof WarcResource) && ((WarcCaptureRecord)record).payload().isPresent() || record instanceof WarcRevisit) {
                    URI id;
                    long position = reader.position();
                    WarcCaptureRecord capture = (WarcCaptureRecord)record;
                    URI uRI = id = record.version().getProtocol().equals("ARC") ? null : record.id();
                    if (record instanceof WarcRevisit && record.contentType().base().equals(MediaType.HTTP)) {
                        ((WarcRevisit)record).http();
                    }
                    record = reader.next().orElse(null);
                    long length = reader.position() - position;
                    String encodedRequest = null;
                    if (this.postAppend) {
                        while (encodedRequest == null && record instanceof WarcCaptureRecord && ((WarcCaptureRecord)record).concurrentTo().contains(id)) {
                            if (record instanceof WarcRequest) {
                                HttpRequest httpRequest = ((WarcRequest)record).http();
                                encodedRequest = CdxRequestEncoder.encode(httpRequest);
                            }
                            record = reader.next().orElse(null);
                        }
                    }
                    this.write(capture, filename, position, length, encodedRequest);
                    continue;
                }
                record = reader.next().orElse(null);
            }
            catch (ParsingException e) {
                this.emitWarning(filename, reader.position(), "ParsingException: " + e.getMessage());
                record = reader.next().orElse(null);
            }
        }
    }

    private void emitWarning(String filename, long position, String message) {
        if (this.warningHandler == null) {
            return;
        }
        this.warningHandler.accept(filename + " (offset " + position + ") " + message);
    }

    public void setRecordFilter(Predicate<WarcRecord> recordFilter) {
        this.recordFilter = recordFilter;
    }

    public void setFormat(CdxFormat format) {
        this.format = format;
    }

    public void setPostAppend(boolean postAppend) {
        this.postAppend = postAppend;
    }

    public void onWarning(Consumer<String> warningHandler) {
        this.warningHandler = warningHandler;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

