/*
 * Decompiled with CFR 0.152.
 */
package org.neuralsandbox;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.tools.maven.plugin.ArtifactFilter;
import org.mule.tools.maven.plugin.MuleArchiver;

public class Deploy
extends AbstractMojo {
    public static final String DEFAULT_NAME = "MuleApplication";
    protected MavenProject project;
    private String name;
    private String version;
    private String username;
    private String password;
    private File classesDirectory;
    protected File appDirectory;
    private URL muleRepositoryUrl;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.name == null) {
            this.getLog().info((CharSequence)"Name is not set, using default \"MuleApplication\"");
            this.name = DEFAULT_NAME;
        }
        if (this.version == null) {
            this.version = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
            this.getLog().info((CharSequence)("Version is not set, using a default of the timestamp: " + this.version));
        }
        if (this.username == null || this.password == null) {
            throw new MojoFailureException((this.username == null ? "Username" : "Password") + " not set.");
        }
        try {
            this.validateProject();
            File file = File.createTempFile("mule", ".zip");
            MuleArchiver archiver = new MuleArchiver();
            archiver.setDestFile(file);
            archiver.addResources(this.appDirectory);
            try {
                archiver.addClasses(this.classesDirectory, null, null);
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)"No classes are present, but still compiling apps.");
            }
            ArtifactFilter filter = new ArtifactFilter(this.project, new ArrayList(), new ArrayList(), true);
            for (Artifact artifact : filter.getArtifactsToArchive()) {
                archiver.addLib(artifact.getFile());
                this.getLog().info((CharSequence)("Added: " + artifact.getArtifactId()));
            }
            archiver.createArchive();
            this.RESTSend(file);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error in attempting to deploy archive: " + e.toString(), (Throwable)e);
        }
    }

    private void validateProject() throws MojoExecutionException {
        File muleConfig = new File(this.appDirectory, "mule-config.xml");
        File deploymentDescriptor = new File(this.appDirectory, "mule-deploy.properties");
        if (!muleConfig.exists() && !deploymentDescriptor.exists()) {
            String message = String.format("No mule-config.xml or mule-deploy.properties in %1s", this.project.getBasedir());
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    private void RESTSend(File packageFile) throws ClientProtocolException, IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.muleRepositoryUrl.toString());
        String authentication_encoded = new String(Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes()));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("file", (ContentBody)new FileBody(packageFile));
        entity.addPart("name", (ContentBody)new StringBody(this.name));
        entity.addPart("version", (ContentBody)new StringBody(this.version));
        post.addHeader("Authorization", "Basic " + authentication_encoded);
        post.setEntity((HttpEntity)entity);
        HttpResponse response = client.execute((HttpUriRequest)post);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200 && statusCode != 201) {
            if (statusCode == 404) {
                HttpResponseException he = new HttpResponseException(404, "The resource was not found.");
                this.getLog().error((CharSequence)("Status Line: " + response.getStatusLine()));
                throw he;
            }
            if (statusCode == 409) {
                HttpResponseException he = new HttpResponseException(409, "The operation was unsuccessful because a resource with that name already exists.");
                this.getLog().error((CharSequence)("Status Line: " + response.getStatusLine()));
                throw he;
            }
            if (statusCode == 500) {
                HttpResponseException he = new HttpResponseException(500, "The operation was unsuccessful.");
                this.getLog().error((CharSequence)("Full HTTP Body: " + EntityUtils.toString((HttpEntity)response.getEntity())));
                throw he;
            }
            HttpResponseException he = new HttpResponseException(statusCode, "Unexpected Status Code Return, Status Line: " + response.getStatusLine());
            this.getLog().error((CharSequence)("Full HTTP Body: " + EntityUtils.toString((HttpEntity)response.getEntity())));
            throw he;
        }
        this.getLog().info((CharSequence)"The operation was successful.");
        this.getLog().info((CharSequence)("Response: " + EntityUtils.toString((HttpEntity)response.getEntity())));
    }
}

