/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.ext;

import java.util.HashMap;
import java.util.Map;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.ext.ExternalTypeRecord;
import org.nfctools.ndef.ext.ExternalTypeRecordConfig;
import org.nfctools.ndef.ext.UnsupportedExternalTypeRecord;
import org.nfctools.ndef.wkt.encoder.RecordEncoder;

public class ExternalTypeEncoder
implements RecordEncoder {
    private Map<Class<?>, ExternalTypeRecordConfig> externalRecordTypes = new HashMap();

    @Override
    public boolean canEncode(Record record) {
        return record instanceof ExternalTypeRecord;
    }

    @Override
    public NdefRecord encodeRecord(Record record, NdefMessageEncoder messageEncoder) {
        byte[] payload;
        String namespace;
        ExternalTypeRecord externalType = (ExternalTypeRecord)record;
        ExternalTypeRecordConfig config = this.externalRecordTypes.get(record.getClass());
        if (config != null) {
            namespace = config.getNamespace();
            payload = config.getContentEncoder().encodeContent(externalType).getBytes(NdefConstants.DEFAULT_CHARSET);
        } else if (externalType instanceof UnsupportedExternalTypeRecord) {
            UnsupportedExternalTypeRecord externalTypeUnsupportedRecord = (UnsupportedExternalTypeRecord)externalType;
            if (!externalTypeUnsupportedRecord.hasContent()) {
                throw new NdefEncoderException("Expected content", record);
            }
            if (!externalTypeUnsupportedRecord.hasNamespace()) {
                throw new NdefEncoderException("Expected namespace", record);
            }
            namespace = externalTypeUnsupportedRecord.getNamespace();
            payload = externalTypeUnsupportedRecord.getContent().getBytes(NdefConstants.DEFAULT_CHARSET);
        } else {
            throw new NdefEncoderException("Unable to encode external type " + ((Object)((Object)externalType)).getClass().getName(), record);
        }
        byte[] type = namespace.getBytes(NdefConstants.DEFAULT_CHARSET);
        return new NdefRecord(4, type, record.getId(), payload);
    }

    public void addRecordConfig(ExternalTypeRecordConfig config) {
        this.externalRecordTypes.put(config.getRecordClass(), config);
    }
}

