/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.ext;

import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.ext.ExternalTypeContentEncoder;
import org.nfctools.ndef.ext.ExternalTypeRecord;
import org.nfctools.ndef.ext.GeoRecord;

public class GeoRecordEncoder
implements ExternalTypeContentEncoder {
    public static String encode(String input) {
        StringBuilder resultStr = new StringBuilder();
        for (char ch : input.toCharArray()) {
            if (ch == ' ') {
                resultStr.append('+');
                continue;
            }
            if (GeoRecordEncoder.isUnsafe(ch)) {
                resultStr.append('%');
                resultStr.append(GeoRecordEncoder.toHex(ch / 16));
                resultStr.append(GeoRecordEncoder.toHex(ch % 16));
                continue;
            }
            resultStr.append(ch);
        }
        return resultStr.toString();
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static boolean isUnsafe(char ch) {
        if (ch > '\u0080' || ch < '\u0000') {
            return true;
        }
        return "%$&+,/:;=?@<>#%".indexOf(ch) != -1;
    }

    @Override
    public String encodeContent(ExternalTypeRecord externalType) {
        GeoRecord geoRecord = (GeoRecord)externalType;
        StringBuilder result = new StringBuilder();
        if (geoRecord.hasCoordinates()) {
            if (geoRecord.hasAddressInformation()) {
                throw new NdefEncoderException("Expected latitude and longitude coordinates or address information, not both.", externalType);
            }
            Double latitude = geoRecord.getLatitude();
            if (latitude > 90.0 || latitude < -90.0) {
                throw new NdefEncoderException("Expected latitude within 90 positive or negative degrees, found " + latitude + " degrees.", externalType);
            }
            Double longitude = geoRecord.getLongitude();
            if (longitude > 180.0 || longitude < -180.0) {
                throw new NdefEncoderException("Expected longitude within 180 positive or negative degrees, found " + longitude + " degrees.", externalType);
            }
            result.append(latitude.toString());
            result.append(',');
            result.append(longitude.toString());
        } else {
            if (geoRecord.hasLatitude()) {
                throw new NdefEncoderException("Expected longitude coordinate set when latitude coordinate set.", externalType);
            }
            if (geoRecord.hasLongitude()) {
                throw new NdefEncoderException("Expected latitude coordinate set when longitude coordinate set.", externalType);
            }
            if (!geoRecord.hasAddressInformation()) {
                throw new NdefEncoderException("Expected coordinates or address information set.", externalType);
            }
            result.append("0,0");
        }
        if (geoRecord.hasAltitude()) {
            result.append(',');
            result.append(geoRecord.getAltitude().toString());
        }
        if (geoRecord.hasAddressInformation()) {
            result.append("?q=");
            result.append(GeoRecordEncoder.encode(geoRecord.getAddressInformation()));
        }
        return result.toString();
    }
}

