/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.mime;

import java.nio.charset.Charset;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.mime.MimeRecord;

public class TextMimeRecord
extends MimeRecord {
    private String content;
    private Charset charset = this.extractContentTypeCharset();

    public TextMimeRecord(String contentType, String content) {
        super(contentType);
        this.content = content;
    }

    public TextMimeRecord(String contentType, byte[] content) {
        super(contentType);
        this.content = new String(content, this.charset);
    }

    public Charset extractContentTypeCharset() {
        int charsetIndex;
        int index = this.contentType.indexOf(59);
        if (index != -1 && (charsetIndex = this.contentType.indexOf("charset=", index)) != -1) {
            int charsetEndIndex = this.contentType.indexOf(59, charsetIndex + 8);
            if (charsetEndIndex == -1) {
                return Charset.forName(this.contentType.substring(charsetIndex + 8));
            }
            return Charset.forName(this.contentType.substring(charsetIndex + 8, charsetEndIndex).trim());
        }
        return NdefConstants.DEFAULT_CHARSET;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public byte[] getContentAsBytes() {
        return this.content.getBytes(this.charset);
    }

    public String toString() {
        return "Content-Type: " + this.contentType + "; Charset: " + this.charset + "; Content: [" + this.getContent() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TextMimeRecord other = (TextMimeRecord)((Object)obj);
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        return !(this.content == null ? other.content != null : !this.content.equals(other.content));
    }
}

