/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.decoder;

import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.handover.records.AlternativeCarrierRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class AlternativeCarrierRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        AlternativeCarrierRecord alternativeCarrierRecord = new AlternativeCarrierRecord();
        alternativeCarrierRecord.setCarrierPowerState(AlternativeCarrierRecord.CarrierPowerState.toCarrierPowerState(payload[0]));
        short carrierDataReferenceLength = payload[1];
        alternativeCarrierRecord.setCarrierDataReference(new String(payload, 2, (int)carrierDataReferenceLength, NdefConstants.DEFAULT_CHARSET));
        int auxiliaryDataReferenceCount = payload[2 + carrierDataReferenceLength];
        int index = 2 + carrierDataReferenceLength + 1;
        for (int i = 0; i < auxiliaryDataReferenceCount; ++i) {
            short auxiliaryDataReferenceLength = payload[index];
            alternativeCarrierRecord.addAuxiliaryDataReference(new String(payload, index + 1, (int)auxiliaryDataReferenceLength, NdefConstants.DEFAULT_CHARSET));
            index += 1 + auxiliaryDataReferenceLength;
        }
        return alternativeCarrierRecord;
    }
}

