/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.decoder;

import java.util.List;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.handover.records.AlternativeCarrierRecord;
import org.nfctools.ndef.wkt.handover.records.ErrorRecord;
import org.nfctools.ndef.wkt.handover.records.HandoverSelectRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverSelectRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        HandoverSelectRecord handoverSelectRecord = new HandoverSelectRecord();
        byte minorVersion = (byte)(payload[0] & 0xF);
        byte majorVersion = (byte)(payload[0] >> 4 & 0xF);
        handoverSelectRecord.setMinorVersion(minorVersion);
        handoverSelectRecord.setMajorVersion(majorVersion);
        List<Record> records = messageDecoder.decodeToRecords(payload, 1, payload.length - 1);
        for (int i = 0; i < records.size(); ++i) {
            Record record = records.get(i);
            if (record instanceof AlternativeCarrierRecord) {
                handoverSelectRecord.add((AlternativeCarrierRecord)record);
                continue;
            }
            if (!(record instanceof ErrorRecord) || i != records.size() - 1) continue;
            handoverSelectRecord.setError((ErrorRecord)record);
        }
        return handoverSelectRecord;
    }
}

