/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.encoder;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.handover.records.HandoverSelectRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverSelectRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        HandoverSelectRecord handoverSelectRecord = (HandoverSelectRecord)wellKnownRecord;
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        payload.write(handoverSelectRecord.getMajorVersion() << 4 | handoverSelectRecord.getMinorVersion());
        if (handoverSelectRecord.hasError() && handoverSelectRecord.hasAlternativeCarriers()) {
            ArrayList<WellKnownRecord> records = new ArrayList<WellKnownRecord>();
            records.addAll(handoverSelectRecord.getAlternativeCarriers());
            records.add(handoverSelectRecord.getError());
            messageEncoder.encode(records, payload);
        } else if (handoverSelectRecord.hasAlternativeCarriers()) {
            messageEncoder.encode(handoverSelectRecord.getAlternativeCarriers(), payload);
        } else if (handoverSelectRecord.hasError()) {
            messageEncoder.encodeSingle(handoverSelectRecord.getError(), payload);
        }
        return payload.toByteArray();
    }
}

