/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.records;

import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class ErrorRecord
extends WellKnownRecord {
    private ErrorReason errorReason;
    private Number errorData;

    public ErrorRecord() {
    }

    public ErrorRecord(ErrorReason errorReason, Number errorData) {
        this.errorReason = errorReason;
        this.errorData = errorData;
    }

    public ErrorReason getErrorReason() {
        return this.errorReason;
    }

    public void setErrorReason(ErrorReason errorReason) {
        this.errorReason = errorReason;
    }

    public Number getErrorData() {
        return this.errorData;
    }

    public void setErrorData(Number errorData) {
        this.errorData = errorData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.errorData == null ? 0 : this.errorData.hashCode());
        result = 31 * result + (this.errorReason == null ? 0 : this.errorReason.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ErrorRecord other = (ErrorRecord)((Object)obj);
        if (this.errorData == null ? other.errorData != null : !this.errorData.equals(other.errorData)) {
            return false;
        }
        return this.errorReason == other.errorReason;
    }

    public boolean hasErrorReason() {
        return this.errorReason != null;
    }

    public boolean hasErrorData() {
        return this.errorData != null;
    }

    public static enum ErrorReason {
        TemporaryMemoryConstraints(1),
        PermanenteMemoryConstraints(2),
        CarrierSpecificConstraints(3);

        private byte value;

        private ErrorReason(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static ErrorReason toErrorReason(byte errorReason) {
            if (errorReason == ErrorReason.TemporaryMemoryConstraints.value) {
                return TemporaryMemoryConstraints;
            }
            if (errorReason == ErrorReason.PermanenteMemoryConstraints.value) {
                return PermanenteMemoryConstraints;
            }
            if (errorReason == ErrorReason.CarrierSpecificConstraints.value) {
                return CarrierSpecificConstraints;
            }
            throw new IllegalArgumentException("Unexpected error reason code " + errorReason);
        }
    }
}

