/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.records;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.wkt.handover.records.AlternativeCarrierRecord;
import org.nfctools.ndef.wkt.handover.records.ErrorRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverSelectRecord
extends WellKnownRecord {
    private byte majorVersion = 1;
    private byte minorVersion = (byte)2;
    private List<AlternativeCarrierRecord> alternativeCarriers;
    private ErrorRecord error;

    public HandoverSelectRecord() {
        this.alternativeCarriers = new ArrayList<AlternativeCarrierRecord>();
    }

    public HandoverSelectRecord(byte majorVersion, byte minorVersion) {
        this(majorVersion, minorVersion, new ArrayList<AlternativeCarrierRecord>());
    }

    public HandoverSelectRecord(byte majorVersion, byte minorVersion, List<AlternativeCarrierRecord> alternativeCarriers) {
        this(majorVersion, minorVersion, alternativeCarriers, null);
    }

    public HandoverSelectRecord(byte majorVersion, byte minorVersion, List<AlternativeCarrierRecord> alternativeCarriers, ErrorRecord error) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.alternativeCarriers = alternativeCarriers;
        this.error = error;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public List<AlternativeCarrierRecord> getAlternativeCarriers() {
        return this.alternativeCarriers;
    }

    public void setAlternativeCarriers(List<AlternativeCarrierRecord> alternativeCarriers) {
        this.alternativeCarriers = alternativeCarriers;
    }

    public ErrorRecord getError() {
        return this.error;
    }

    public void setError(ErrorRecord error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean hasAlternativeCarriers() {
        return !this.alternativeCarriers.isEmpty();
    }

    public void add(AlternativeCarrierRecord record) {
        this.alternativeCarriers.add(record);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternativeCarriers == null ? 0 : this.alternativeCarriers.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HandoverSelectRecord other = (HandoverSelectRecord)((Object)obj);
        if (this.alternativeCarriers == null ? other.alternativeCarriers != null : !this.alternativeCarriers.equals(other.alternativeCarriers)) {
            return false;
        }
        if (this.error == null ? other.error != null : !this.error.equals((Object)other.error)) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        return this.minorVersion == other.minorVersion;
    }
}

