/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.records;

import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.records.TextRecord;
import org.nfctools.ndef.wkt.records.UriRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class GcTargetRecord
extends WellKnownRecord {
    private Record targetIdentifier;

    public GcTargetRecord(Record targetIdentifier) {
        this.setTargetIdentifier(targetIdentifier);
    }

    public GcTargetRecord() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTargetIdentifier(Record targetIdentifier) {
        if (targetIdentifier != null) {
            if (!(targetIdentifier instanceof UriRecord) && !(targetIdentifier instanceof TextRecord)) throw new IllegalArgumentException(targetIdentifier.getClass().getName() + " not supported as target identifier");
            this.targetIdentifier = targetIdentifier;
            return;
        } else {
            this.targetIdentifier = null;
        }
    }

    public Record getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public String toString() {
        return "Target: [" + this.targetIdentifier + "]";
    }

    public boolean hasTargetIdentifier() {
        return this.targetIdentifier != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.targetIdentifier == null ? 0 : this.targetIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GcTargetRecord other = (GcTargetRecord)((Object)obj);
        return !(this.targetIdentifier == null ? other.targetIdentifier != null : !this.targetIdentifier.equals((Object)other.targetIdentifier));
    }
}

