/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.records;

import java.nio.charset.Charset;
import java.util.Locale;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class TextRecord
extends WellKnownRecord {
    public static final byte LANGUAGE_CODE_MASK = 31;
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16BE");
    private String text;
    private Charset encoding;
    private Locale locale;

    public TextRecord(String key, String text) {
        this(text, UTF8, Locale.getDefault());
        this.setKey(key);
    }

    public TextRecord(String text) {
        this(text, UTF8, Locale.getDefault());
    }

    public TextRecord(String text, Locale locale) {
        this(text, UTF8, locale);
    }

    public TextRecord(String text, Charset encoding, Locale locale) {
        this.encoding = encoding;
        this.text = text;
        this.locale = locale;
        if (!encoding.equals(UTF8) && !encoding.equals(UTF16)) {
            throw new IllegalArgumentException("unsupported encoding. only utf8 and utf16 are allowed.");
        }
    }

    public TextRecord() {
    }

    public String getText() {
        return this.text;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Title: [");
        if (this.hasKey()) {
            sb.append("Key/Id: ").append(this.getKey()).append(", ");
        }
        sb.append("Text: ").append(this.text).append(", ");
        sb.append("Locale: " + this.locale.getLanguage()).append(this.locale.getCountry() == null || this.locale.getCountry().length() == 0 ? "" : "-" + this.locale.getCountry());
        sb.append("]");
        return sb.toString();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setEncoding(Charset encoding) {
        if (!encoding.equals(UTF8) && !encoding.equals(UTF16)) {
            throw new IllegalArgumentException("unsupported encoding. only utf8 and utf16 are allowed.");
        }
        this.encoding = encoding;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean hasText() {
        return this.text != null;
    }

    public boolean hasLocale() {
        return this.locale != null;
    }

    public boolean hasEncoding() {
        return this.encoding != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TextRecord other = (TextRecord)((Object)obj);
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

