/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.File;
import java.util.ArrayList;
import net.grinder.common.GrinderProperties;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.common.ThreadLifeCycleListener;
import net.grinder.common.processidentity.WorkerIdentity;
import net.grinder.communication.Sender;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.ExternalLogger;
import net.grinder.engine.process.GrinderProcess;
import net.grinder.engine.process.JUnitThreadContextUpdater;
import net.grinder.engine.process.JavaDCRInstrumenterEx;
import net.grinder.engine.process.MasterInstrumenter;
import net.grinder.engine.process.NullSender;
import net.grinder.engine.process.PluginRegistryImplementation;
import net.grinder.engine.process.SSLControlImplementation;
import net.grinder.engine.process.ScriptContextImplementation;
import net.grinder.engine.process.ScriptStatisticsImplementation;
import net.grinder.engine.process.SimpleWorkerIdentity;
import net.grinder.engine.process.TestRegistryImplementation;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.engine.process.TestStatisticsHelperImplementation;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextImplementation;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.engine.process.dcr.DCRContextImplementation;
import net.grinder.script.Grinder;
import net.grinder.script.SSLControl;
import net.grinder.script.Statistics;
import net.grinder.script.TestRegistry;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsServicesImplementation;
import net.grinder.util.Sleeper;
import net.grinder.util.SleeperImplementation;
import net.grinder.util.weave.agent.ExposeInstrumentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitThreadContextInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnitThreadContextInitializer.class);
    private final GrinderProcess.ThreadContexts m_threadContexts = new GrinderProcess.ThreadContexts();
    private final GrinderProcess.Times m_times = new GrinderProcess.Times();
    private StatisticsServices m_statisticsServices;

    public void initialize() {
        this.m_statisticsServices = StatisticsServicesImplementation.getInstance();
        ArrayList<JavaDCRInstrumenterEx> list = new ArrayList<JavaDCRInstrumenterEx>();
        DCRContextImplementation context = DCRContextImplementation.create((Logger)LOGGER);
        if (context == null) {
            String file = ExposeInstrumentation.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            file = new File(file).getAbsolutePath();
            throw new RuntimeException("Please add \r\n-javaagent:" + file + "\r\nin 'Run As JUnit' vm argument.");
        }
        list.add(new JavaDCRInstrumenterEx((DCRContext)context));
        MasterInstrumenter instrumenter = new MasterInstrumenter(list);
        TestStatisticsHelperImplementation m_testStatisticsHelper = new TestStatisticsHelperImplementation(this.m_statisticsServices.getStatisticsIndexMap());
        TestRegistryImplementation m_testRegistryImplementation = new TestRegistryImplementation((ThreadContextLocator)this.m_threadContexts, this.m_statisticsServices.getStatisticsSetFactory(), (TestStatisticsHelper)m_testStatisticsHelper, this.m_times.getTimeAuthority());
        m_testRegistryImplementation.setInstrumenter((Instrumenter)instrumenter);
        ExternalLogger externalLogger = new ExternalLogger(LOGGER, (ThreadContextLocator)this.m_threadContexts);
        SleeperImplementation m_sleeper = new SleeperImplementation(this.m_times.getTimeAuthority(), (Logger)externalLogger, 1.0, 0.2);
        ScriptStatisticsImplementation scriptStatistics = new ScriptStatisticsImplementation((ThreadContextLocator)this.m_threadContexts, this.m_statisticsServices, (Sender)new NullSender());
        ScriptContextImplementation scriptContext = new ScriptContextImplementation((WorkerIdentity)new SimpleWorkerIdentity("unit-test", 0), (WorkerIdentity)new SimpleWorkerIdentity("unit-test", 0), (ThreadContextLocator)this.m_threadContexts, null, (Logger)externalLogger, (Sleeper)m_sleeper, (SSLControl)new SSLControlImplementation((ThreadContextLocator)this.m_threadContexts), (Statistics)scriptStatistics, (TestRegistry)m_testRegistryImplementation, null, null, null, null);
        Grinder.grinder = scriptContext;
        new PluginRegistryImplementation((Logger)externalLogger, (Grinder.ScriptContext)scriptContext, (ThreadContextLocator)this.m_threadContexts, this.m_statisticsServices, this.m_times.getTimeAuthority());
    }

    public void attachWorkerThreadContext() {
        try {
            if (this.m_threadContexts.get() == null) {
                GrinderProperties properties = new GrinderProperties();
                properties.setInt("grinder.agents", 1);
                properties.setInt("grinder.processes", 1);
                properties.setInt("grinder.threads", 1);
                properties.setBoolean("grinder.logData", false);
                final ThreadContextImplementation threadContext = new ThreadContextImplementation(properties, this.m_statisticsServices, 0, LOGGER);
                this.m_threadContexts.threadCreated((ThreadContext)threadContext);
                this.m_threadContexts.threadStarted((ThreadContext)threadContext);
                threadContext.registerThreadLifeCycleListener((ThreadLifeCycleListener)new SkeletonThreadLifeCycleListener(){

                    public void endThread() {
                        threadContext.reportPendingDispatchContext();
                    }

                    public void endRun() {
                    }
                });
            }
        }
        catch (EngineException e) {
            LOGGER.error("Error while initiating thread context", (Throwable)e);
        }
    }

    public void detachWorkerThreadContext() {
        ThreadContext threadContext = this.m_threadContexts.get();
        if (threadContext != null) {
            threadContext.fireEndThreadEvent();
            this.m_threadContexts.threadStarted(null);
        }
    }

    public JUnitThreadContextUpdater getThreadContextUpdater() {
        return new JUnitThreadContextUpdater(this.m_threadContexts);
    }
}

