/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.exception;

import java.util.ArrayList;
import net.grinder.util.Sleeper;

public abstract class AbstractExceptionProcessor {
    public Throwable filterException(Throwable throwable) {
        return this.sanitize(this.getRootCause(throwable));
    }

    public Throwable getRootCause(Throwable throwable) {
        Throwable t = throwable;
        Throwable cause = t.getCause();
        while (cause != null) {
            if (this.isGenericShutdown(cause)) {
                return cause;
            }
            t = cause;
            cause = t.getCause();
        }
        return t;
    }

    public boolean isGenericShutdown(Throwable cause) {
        while (cause != null) {
            if (cause.getClass().getName().equals("net.grinder.engine.process.ShutdownException") || cause instanceof Sleeper.ShutdownException) {
                return true;
            }
            cause = cause.getCause();
        }
        return false;
    }

    public Throwable sanitize(Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            StackTraceElement[] trace = t.getStackTrace();
            ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
            for (StackTraceElement stackTraceElement : trace) {
                if (!this.isApplicationClass(stackTraceElement.getClassName())) continue;
                newTrace.add(stackTraceElement);
            }
            StackTraceElement[] clean = new StackTraceElement[newTrace.size()];
            newTrace.toArray(clean);
            t.setStackTrace(clean);
        }
        return throwable;
    }

    public boolean isApplicationClass(String className) {
        for (String groovyPackage : this.getUninterestingPackages()) {
            if (!className.startsWith(groovyPackage)) continue;
            return false;
        }
        return true;
    }

    protected abstract String[] getInterestingPackages();

    protected abstract String[] getUninterestingPackages();
}

