/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovySystem;
import java.io.IOException;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.script.Grinder;
import net.grinder.script.Statistics;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.ScriptExecutionException;
import net.grinder.scriptengine.exception.AbstractExceptionProcessor;
import net.grinder.scriptengine.groovy.GrinderContextExecutor;
import net.grinder.scriptengine.groovy.GroovyExceptionProcessor;
import net.grinder.util.NoOp;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class GroovyScriptEngine
implements ScriptEngineService.ScriptEngine {
    private final AbstractExceptionProcessor exceptionProcessor = new GroovyExceptionProcessor();
    private final GrinderContextExecutor m_grinderRunner;
    Class<?> m_groovyClass;

    public GroovyScriptEngine(ScriptLocation script) throws EngineException {
        ClassLoader parent = this.getClass().getClassLoader();
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setSourceEncoding("UTF-8");
        GroovyClassLoader loader = new GroovyClassLoader(parent, configuration, true);
        try {
            this.m_groovyClass = loader.parseClass(script.getFile());
            this.m_grinderRunner = new GrinderContextExecutor(this.m_groovyClass);
            this.m_grinderRunner.runBeforeProcess();
            assert (this.m_grinderRunner.testCount() > 0);
        }
        catch (IOException io) {
            throw new EngineException("Unable to parse groovy script at: " + script.getFile().getAbsolutePath(), (Throwable)io);
        }
        catch (Throwable e) {
            throw new EngineException("Error while initialize test runner", e);
        }
    }

    public ScriptEngineService.WorkerRunnable createWorkerRunnable() throws EngineException {
        try {
            return new GroovyWorkerRunnable(new GrinderContextExecutor(this.m_groovyClass));
        }
        catch (InitializationError e) {
            throw new EngineException("Exception occurred during initializing runner", this.exceptionProcessor.sanitize(e));
        }
    }

    public ScriptEngineService.WorkerRunnable createWorkerRunnable(Object testRunner) throws EngineException {
        try {
            return new GroovyWorkerRunnable(new GrinderContextExecutor(this.m_groovyClass, testRunner));
        }
        catch (InitializationError e) {
            throw new EngineException("Exception occurred during initializing runner", this.exceptionProcessor.sanitize(e));
        }
    }

    public void shutdown() throws EngineException {
        this.m_grinderRunner.runAfterProcess();
    }

    public String getDescription() {
        return String.format("GroovyScriptEngine running with groovy version: %s", GroovySystem.getVersion());
    }

    public static final class GroovyScriptExecutionException
    extends ScriptExecutionException {
        private static final long serialVersionUID = -1789749790500700831L;

        public GroovyScriptExecutionException(String message) {
            super(message);
        }

        public GroovyScriptExecutionException(String s, Throwable t) {
            super(s, t);
        }
    }

    public final class GroovyWorkerRunnable
    implements ScriptEngineService.WorkerRunnable {
        private final GrinderContextExecutor m_groovyThreadRunner;
        private final RunNotifier notifier = new RunNotifier(){

            public void fireTestFailure(Failure failure) {
                if (GroovyScriptEngine.this.exceptionProcessor.isGenericShutdown(failure.getException())) {
                    if (failure.getException() instanceof RuntimeException) {
                        throw (RuntimeException)failure.getException();
                    }
                    throw new RuntimeException("Wrapped", failure.getException());
                }
                super.fireTestFailure(failure);
            }
        };

        private GroovyWorkerRunnable(GrinderContextExecutor groovyRunner) throws EngineException {
            this.m_groovyThreadRunner = groovyRunner;
            this.notifier.addListener(new RunListener(){

                public void testFailure(Failure failure) {
                    Throwable rootCause = GroovyScriptEngine.this.exceptionProcessor.getRootCause(failure.getException());
                    if (GroovyScriptEngine.this.exceptionProcessor.isGenericShutdown(rootCause)) {
                        return;
                    }
                    Grinder.grinder.getLogger().error(failure.getMessage(), GroovyScriptEngine.this.exceptionProcessor.filterException(rootCause));
                    try {
                        Statistics.StatisticsForTest forLastTest = Grinder.grinder.getStatistics().getForLastTest();
                        if (forLastTest != null) {
                            forLastTest.setSuccess(false);
                        }
                    }
                    catch (Throwable t) {
                        NoOp.noOp();
                    }
                }
            });
            this.m_groovyThreadRunner.runBeforeThread();
        }

        public void run() throws ScriptExecutionException {
            block2: {
                try {
                    this.m_groovyThreadRunner.run(this.notifier);
                }
                catch (RuntimeException e) {
                    if (!GroovyScriptEngine.this.exceptionProcessor.isGenericShutdown(e)) break block2;
                    throw new GroovyScriptExecutionException("Shutdown", e.getMessage().equals("Wrapped") ? e.getCause() : e);
                }
            }
        }

        public void shutdown() throws ScriptExecutionException {
            this.notifier.pleaseStop();
            this.m_groovyThreadRunner.runAfterThread();
        }
    }
}

