/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy;

import java.util.Collections;
import java.util.List;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.groovy.GroovyScriptEngine;
import net.grinder.util.FileExtensionMatcher;

public class GroovyScriptEngineService
implements ScriptEngineService {
    private final FileExtensionMatcher m_groovyFileMatcher = new FileExtensionMatcher(".groovy");
    private final boolean m_forceDCRInstrumentation;

    public GroovyScriptEngineService(GrinderProperties properties, DCRContext dcrContext, ScriptLocation scriptLocation) {
        this.m_forceDCRInstrumentation = properties.getBoolean("grinder.dcrinstrumentation", false) || this.m_groovyFileMatcher.accept(scriptLocation.getFile());
    }

    public GroovyScriptEngineService() {
        this.m_forceDCRInstrumentation = false;
    }

    public List<Instrumenter> createInstrumenters() {
        return Collections.emptyList();
    }

    public ScriptEngineService.ScriptEngine createScriptEngine(ScriptLocation script) throws EngineException {
        if (this.m_groovyFileMatcher.accept(script.getFile())) {
            return new GroovyScriptEngine(script);
        }
        return null;
    }
}

