/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.grinder.engine.process.JUnitThreadContextInitializer;
import net.grinder.engine.process.JUnitThreadContextUpdater;
import net.grinder.scriptengine.exception.AbstractExceptionProcessor;
import net.grinder.scriptengine.groovy.GroovyExceptionProcessor;
import net.grinder.scriptengine.groovy.junit.PerThreadStatement;
import net.grinder.scriptengine.groovy.junit.RepetitionStatement;
import net.grinder.scriptengine.groovy.junit.RunAfterThreads;
import net.grinder.scriptengine.groovy.junit.RunBeforeThreads;
import net.grinder.scriptengine.groovy.junit.RunRateStatement;
import net.grinder.scriptengine.groovy.junit.TestObjectFactory;
import net.grinder.scriptengine.groovy.junit.annotation.AfterProcess;
import net.grinder.scriptengine.groovy.junit.annotation.AfterThread;
import net.grinder.scriptengine.groovy.junit.annotation.BeforeProcess;
import net.grinder.scriptengine.groovy.junit.annotation.BeforeThread;
import net.grinder.scriptengine.groovy.junit.annotation.Repeat;
import net.grinder.scriptengine.groovy.junit.annotation.RunRate;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.MethodRule;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class GrinderRunner
extends BlockJUnit4ClassRunner {
    private final TestObjectFactory testTargetFactory;
    private final AbstractExceptionProcessor exceptionProcessor = new GroovyExceptionProcessor();
    private final Map<FrameworkMethod, Statement> frameworkMethodCache = new HashMap<FrameworkMethod, Statement>();
    private JUnitThreadContextInitializer threadContextInitializer;
    private JUnitThreadContextUpdater threadContextUpdater;
    private PerThreadStatement finalPerThreadStatement;
    private boolean enableRateRunner = true;

    public GrinderRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.testTargetFactory = new TestObjectFactory(){

            @Override
            public TestClass getTestClass() {
                return GrinderRunner.this.getTestClass();
            }

            @Override
            public Object createTest() throws Exception {
                return GrinderRunner.this.createTest();
            }
        };
        this.initializeGrinderContext();
    }

    public GrinderRunner(Class<?> klass, final Object runner) throws InitializationError {
        super(klass);
        this.testTargetFactory = new TestObjectFactory(){

            @Override
            public TestClass getTestClass() {
                return GrinderRunner.this.getTestClass();
            }

            @Override
            public Object createTest() {
                return runner;
            }
        };
        this.initializeGrinderContext();
    }

    protected void initializeGrinderContext() {
        this.threadContextInitializer = new JUnitThreadContextInitializer();
        this.threadContextInitializer.initialize();
        this.threadContextUpdater = this.threadContextInitializer.getThreadContextUpdater();
        this.finalPerThreadStatement = new PerThreadStatement(){

            @Override
            void before() {
                GrinderRunner.this.attachWorker();
            }

            @Override
            void after() {
                GrinderRunner.this.detachWorker();
            }
        };
    }

    protected List<FrameworkMethod> getChildren() {
        return super.getChildren();
    }

    public void run(RunNotifier notifier) {
        this.registerRunNotifierListener(notifier);
        Description description = this.getDescription();
        this.enableRateRunner = this.isRateRunnerEnabled();
        EachTestNotifier testNotifier = new EachTestNotifier(notifier, description);
        try {
            Statement statement = this.classBlock(notifier);
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            testNotifier.fireTestIgnored();
        }
        catch (StoppedByUserException e) {
            throw e;
        }
        catch (Throwable e) {
            testNotifier.addFailure(e);
        }
    }

    protected boolean isRateRunnerEnabled() {
        Description description = this.getDescription();
        return description.testCount() > 1 && this.isRepeatRunnerEnabled();
    }

    private boolean isRepeatRunnerEnabled() {
        Annotation[] annotations = this.getTestClass().getAnnotations();
        boolean repeatAnnotation = false;
        for (Annotation each : annotations) {
            if (!each.annotationType().equals(Repeat.class)) continue;
            repeatAnnotation = true;
        }
        return repeatAnnotation;
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        statement = this.withRepeat(statement);
        statement = this.withBeforeThread(statement);
        statement = this.withBeforeProcess(statement);
        statement = this.withAfterThread(statement);
        statement = this.withAfterProcess(statement);
        return statement;
    }

    protected Statement withRepeat(Statement statement) {
        Annotation[] annotations = this.getTestClass().getAnnotations();
        int repetition = 1;
        for (Annotation each : annotations) {
            if (!each.annotationType().equals(Repeat.class)) continue;
            repetition = ((Repeat)each).value();
        }
        return new RepetitionStatement(statement, repetition, this.threadContextUpdater);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement statement = this.frameworkMethodCache.get(method);
        if (statement != null) {
            return statement;
        }
        Object testObject = this.testTargetFactory.getTestObject();
        statement = this.methodInvoker(method, testObject);
        statement = this.possiblyExpectingExceptions(method, testObject, statement);
        statement = this.withPotentialTimeout(method, testObject, statement);
        statement = this.withBefores(method, testObject, statement);
        statement = this.withAfters(method, testObject, statement);
        statement = this.withRules(method, testObject, statement);
        if (this.enableRateRunner) {
            statement = this.withRunRate(method, testObject, statement);
        }
        this.frameworkMethodCache.put(method, statement);
        return statement;
    }

    protected Statement withRunRate(FrameworkMethod method, Object target, Statement statement) {
        RunRate runRate = (RunRate)method.getAnnotation(RunRate.class);
        return runRate == null ? statement : new RunRateStatement(statement, runRate.value());
    }

    private Statement withRules(FrameworkMethod method, Object target, Statement statement) {
        Statement result = statement;
        for (MethodRule each : this.getTestClass().getAnnotatedFieldValues(target, Rule.class, MethodRule.class)) {
            result = each.apply(result, method, target);
        }
        return result;
    }

    protected Statement withBeforeProcess(Statement statement) {
        TestClass testClass = this.getTestClass();
        ArrayList befores = new ArrayList(testClass.getAnnotatedMethods(BeforeProcess.class));
        befores.addAll(testClass.getAnnotatedMethods(BeforeClass.class));
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, null);
    }

    protected Statement withAfterProcess(Statement statement) {
        TestClass testClass = this.getTestClass();
        ArrayList afters = new ArrayList(testClass.getAnnotatedMethods(AfterProcess.class));
        afters.addAll(testClass.getAnnotatedMethods(AfterClass.class));
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, null);
    }

    protected Statement withAfterThread(Statement statement) {
        List afterThreads = this.getTestClass().getAnnotatedMethods(AfterThread.class);
        return new RunAfterThreads(statement, afterThreads, this.testTargetFactory, this.finalPerThreadStatement);
    }

    protected Statement withBeforeThread(Statement statement) {
        List beforeThreads = this.getTestClass().getAnnotatedMethods(BeforeThread.class);
        return new RunBeforeThreads(statement, beforeThreads, this.testTargetFactory, this.finalPerThreadStatement);
    }

    protected void registerRunNotifierListener(RunNotifier notifier) {
        notifier.addFirstListener(new RunListener(){

            public void testStarted(Description description) {
            }

            public void testRunStarted(Description description) {
                GrinderRunner.this.attachWorker();
            }

            public void testRunFinished(Result result) {
                GrinderRunner.this.detachWorker();
            }

            public void testFailure(Failure failure) {
                Throwable filtered;
                Throwable exception = failure.getException();
                if (exception != (filtered = GrinderRunner.this.exceptionProcessor.filterException(exception))) {
                    exception.initCause(filtered);
                }
            }
        });
    }

    void attachWorker() {
        this.threadContextInitializer.attachWorkerThreadContext();
    }

    void detachWorker() {
        this.threadContextInitializer.detachWorkerThreadContext();
    }
}

