/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy.junit;

import net.grinder.engine.process.JUnitThreadContextUpdater;
import org.junit.runners.model.Statement;

public class RepetitionStatement
extends Statement {
    private final int repetition;
    private final Statement statement;
    private JUnitThreadContextUpdater threadContextUpdater;

    public RepetitionStatement(Statement statement, int repetition) {
        this.statement = statement;
        this.repetition = Math.max(repetition, 1);
    }

    public RepetitionStatement(Statement statement, int repetition, JUnitThreadContextUpdater threadContextUpdater) {
        this.statement = statement;
        this.threadContextUpdater = threadContextUpdater;
        this.repetition = Math.max(repetition, 1);
    }

    public void evaluate() throws Throwable {
        for (int i = 0; i < this.repetition; ++i) {
            if (this.threadContextUpdater != null) {
                this.threadContextUpdater.setRunCount(i);
            }
            this.statement.evaluate();
        }
    }
}

