/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy.junit;

import java.util.List;
import net.grinder.scriptengine.groovy.junit.PerThreadStatement;
import net.grinder.scriptengine.groovy.junit.TestObjectFactory;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class RunAfterThreads
extends Statement {
    private final Statement fNext;
    private final TestObjectFactory fFactory;
    private final List<FrameworkMethod> fBefores;
    private final PerThreadStatement flastPerThreadStatement;

    public RunAfterThreads(Statement next, List<FrameworkMethod> afterThread, TestObjectFactory factory, PerThreadStatement lastPerThreadStatement) {
        this.fNext = next;
        this.fBefores = afterThread;
        this.fFactory = factory;
        this.flastPerThreadStatement = lastPerThreadStatement;
    }

    public void evaluate() throws Throwable {
        this.fNext.evaluate();
        Object testObject = this.fFactory.getTestObject();
        for (FrameworkMethod before : this.fBefores) {
            before.invokeExplosively(testObject, new Object[0]);
        }
        if (this.flastPerThreadStatement != null) {
            this.flastPerThreadStatement.after();
        }
    }
}

