/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy.junit;

import java.util.List;
import net.grinder.scriptengine.groovy.junit.PerThreadStatement;
import net.grinder.scriptengine.groovy.junit.TestObjectFactory;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

class RunBeforeThreads
extends Statement {
    private final Statement fNext;
    private final TestObjectFactory fFactory;
    private final List<FrameworkMethod> fBefores;
    private final PerThreadStatement fFirstPerThreadStatement;

    public RunBeforeThreads(Statement next, List<FrameworkMethod> befores, TestObjectFactory factory, PerThreadStatement firstPerThreadStatement) {
        this.fNext = next;
        this.fBefores = befores;
        this.fFactory = factory;
        this.fFirstPerThreadStatement = firstPerThreadStatement;
    }

    public void evaluate() throws Throwable {
        if (this.fFirstPerThreadStatement != null) {
            this.fFirstPerThreadStatement.before();
        }
        Object testObject = this.fFactory.getTestObject();
        for (FrameworkMethod before : this.fBefores) {
            before.invokeExplosively(testObject, new Object[0]);
        }
        this.fNext.evaluate();
    }
}

