/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy.junit;

import net.grinder.script.Grinder;
import org.junit.runners.model.Statement;

public class RunRateStatement
extends Statement {
    private final Statement statement;
    private final float interval;
    private final float percent;

    public RunRateStatement(Statement statement, int runRate) {
        this.statement = statement;
        runRate = Math.max(Math.min(runRate, 100), 0);
        this.interval = 100.0f / (float)runRate;
        this.percent = (float)runRate / 100.0f + 1.2E-8f;
    }

    public void evaluate() throws Throwable {
        if (this.checkRun(Grinder.grinder.getRunNumber())) {
            this.statement.evaluate();
        }
    }

    private boolean checkRun(int i) {
        float f = (float)i / this.interval;
        return (int)f != (int)(f + this.percent);
    }
}

