/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.groovy.junit;

import java.util.HashMap;
import java.util.Map;
import org.junit.internal.runners.model.ReflectiveCallable;
import org.junit.internal.runners.statements.Fail;
import org.junit.runners.model.TestClass;

abstract class TestObjectFactory {
    private final Map<TestClass, Object> testObjectMap = new HashMap<TestClass, Object>();

    public Object getTestObject() {
        Object testObject = this.testObjectMap.get(this.getTestClass());
        if (testObject == null) {
            try {
                ReflectiveCallable reflectiveCallable = new ReflectiveCallable(){

                    protected Object runReflectiveCall() throws Throwable {
                        return TestObjectFactory.this.createTest();
                    }
                };
                testObject = reflectiveCallable.run();
                this.testObjectMap.put(this.getTestClass(), testObject);
            }
            catch (Throwable e) {
                return new Fail(e);
            }
        }
        return testObject;
    }

    public abstract TestClass getTestClass();

    public abstract Object createTest() throws Exception;
}

