/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.GrinderProperties;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.ProcessLifeCycleListener;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.WorkerRunnableFactory;
import net.grinder.engine.process.WorkerThreadSynchronisation;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.ScriptExecutionException;
import net.grinder.util.Sleeper;
import org.slf4j.Logger;

class GrinderThread
implements Runnable {
    private final Logger m_logger;
    private final WorkerThreadSynchronisation m_threadSynchronisation;
    private final ProcessLifeCycleListener m_processLifeCycle;
    private final GrinderProperties m_properties;
    private final Sleeper m_sleeper;
    private final ThreadContext m_context;
    private final WorkerRunnableFactory m_workerRunnableFactory;

    public GrinderThread(Logger logger, ThreadContext context, WorkerThreadSynchronisation threadSynchronisation, ProcessLifeCycleListener processLifeCycle, GrinderProperties properties, Sleeper sleeper, WorkerRunnableFactory workerRunnableFactory) throws EngineException {
        this.m_logger = logger;
        this.m_context = context;
        this.m_threadSynchronisation = threadSynchronisation;
        this.m_processLifeCycle = processLifeCycle;
        this.m_properties = properties;
        this.m_sleeper = sleeper;
        this.m_workerRunnableFactory = workerRunnableFactory;
        this.m_processLifeCycle.threadCreated(this.m_context);
        this.m_threadSynchronisation.threadCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_processLifeCycle.threadStarted(this.m_context);
        this.m_context.setCurrentRunNumber(-1);
        this.m_context.fireBeginThreadEvent();
        try {
            int currentRun;
            ScriptEngineService.WorkerRunnable workerRunnable = this.m_workerRunnableFactory.create();
            int numberOfRuns = this.m_properties.getInt("grinder.runs", 1);
            if (numberOfRuns == 0) {
                this.m_logger.info(this.m_context.getLogMarker(), "starting, will run forever");
            } else {
                this.m_logger.info(this.m_context.getLogMarker(), "starting, will do {} run{}", (Object)numberOfRuns, (Object)(numberOfRuns == 1 ? "" : "s"));
            }
            this.m_threadSynchronisation.awaitStart();
            this.m_sleeper.sleepFlat(this.m_properties.getLong("grinder.initialSleepTime", 0L));
            for (currentRun = 0; numberOfRuns == 0 || currentRun < numberOfRuns; ++currentRun) {
                this.m_context.setCurrentRunNumber(currentRun);
                this.m_context.fireBeginRunEvent();
                try {
                    workerRunnable.run();
                }
                catch (ShutdownException e) {
                    this.m_logger.info(this.m_context.getLogMarker(), "Thread has been shut down");
                    break;
                }
                catch (ScriptExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ShutdownException || cause instanceof Sleeper.ShutdownException) {
                        this.m_logger.info(this.m_context.getLogMarker(), "shut down");
                        break;
                    }
                    this.m_logger.error(this.m_context.getLogMarker(), "Aborted run: " + e.getShortMessage(), (Throwable)e);
                }
                this.m_context.fireEndRunEvent();
            }
            this.m_context.setCurrentRunNumber(-1);
            this.m_logger.info(this.m_context.getLogMarker(), "finished {} {}", (Object)currentRun, (Object)(currentRun == 1 ? "run" : "runs"));
            this.m_context.fireBeginShutdownEvent();
            try {
                workerRunnable.shutdown();
            }
            catch (ScriptExecutionException e) {
                this.m_logger.error(this.m_context.getLogMarker(), "Aborted test runner shut down: " + e.getShortMessage(), (Throwable)e);
            }
            this.m_context.fireEndThreadEvent();
        }
        catch (ScriptExecutionException e) {
            this.m_logger.error(this.m_context.getLogMarker(), "Aborting thread: {}" + e.getShortMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.m_logger.error(this.m_context.getLogMarker(), "Aborting thread: " + e, (Throwable)e);
        }
        finally {
            this.m_context.setCurrentRunNumber(-1);
            this.m_threadSynchronisation.threadFinished();
        }
    }
}

