/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.util.ArrayList;
import java.util.List;
import net.grinder.common.GrinderProperties;
import net.grinder.common.SSLContextFactory;
import net.grinder.common.SkeletonThreadLifeCycleListener;
import net.grinder.common.Test;
import net.grinder.common.ThreadLifeCycleListener;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.DispatchContext;
import net.grinder.engine.process.DispatchResultReporter;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadDataLogger;
import net.grinder.script.Statistics;
import net.grinder.statistics.StatisticsServices;
import net.grinder.statistics.StatisticsSet;
import net.grinder.util.ListenerSupport;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

final class ThreadContextImplementation
implements ThreadContext {
    private final ListenerSupport<ThreadLifeCycleListener> m_threadLifeCycleListeners = new ListenerSupport();
    private final DispatchContextStack m_dispatchContextStack = new DispatchContextStack();
    private final int m_threadNumber;
    private final Marker m_threadMarker;
    private final DispatchResultReporter m_dispatchResultReporter;
    private SSLContextFactory m_sslContextFactory;
    private boolean m_delayReports;
    private DispatchContext m_pendingDispatchContext;
    private Statistics.StatisticsForTest m_statisticsForLastTest;
    private Marker m_runMarker;
    private int m_runNumber = -1;
    private Marker m_testMarker;
    private volatile boolean m_shutdown;
    private boolean m_shutdownReported;

    public ThreadContextImplementation(GrinderProperties properties, StatisticsServices statisticsServices, int threadNumber, Logger dataLogger) throws EngineException {
        this.m_threadNumber = threadNumber;
        this.m_threadMarker = MarkerFactory.getMarker((String)("thread-" + threadNumber));
        if (properties.getBoolean("grinder.logData", true)) {
            final ThreadDataLogger threadDataLogger = new ThreadDataLogger(dataLogger, statisticsServices.getDetailStatisticsView().getExpressionViews(), this.m_threadNumber);
            this.m_dispatchResultReporter = new DispatchResultReporter(){

                public void report(Test test, long startTime, StatisticsSet statistics) {
                    threadDataLogger.report(ThreadContextImplementation.this.getRunNumber(), test, startTime, statistics);
                }
            };
        } else {
            this.m_dispatchResultReporter = new DispatchResultReporter(){

                public void report(Test test, long startTime, StatisticsSet statistics) {
                }
            };
        }
        this.registerThreadLifeCycleListener((ThreadLifeCycleListener)new SkeletonThreadLifeCycleListener(){

            public void endRun() {
                ThreadContextImplementation.this.reportPendingDispatchContext();
            }
        });
    }

    public int getThreadNumber() {
        return this.m_threadNumber;
    }

    public int getRunNumber() {
        return this.m_runNumber;
    }

    public void setCurrentRunNumber(int run) {
        if (this.m_runMarker != null) {
            this.m_threadMarker.remove(this.m_runMarker);
            MarkerFactory.getIMarkerFactory().detachMarker(this.m_runMarker.getName());
        }
        if (run != -1) {
            this.m_runMarker = MarkerFactory.getMarker((String)("run-" + run));
            this.m_threadMarker.add(this.m_runMarker);
        }
        this.m_runNumber = run;
    }

    void setTestLogMarker(Marker marker) {
        if (this.m_testMarker != null) {
            this.m_threadMarker.remove(this.m_testMarker);
        }
        this.m_testMarker = marker;
        if (marker != null) {
            this.m_threadMarker.add(marker);
        }
    }

    public SSLContextFactory getThreadSSLContextFactory() {
        return this.m_sslContextFactory;
    }

    public void setThreadSSLContextFactory(SSLContextFactory sslContextFactory) {
        this.m_sslContextFactory = sslContextFactory;
    }

    public DispatchResultReporter getDispatchResultReporter() {
        return this.m_dispatchResultReporter;
    }

    public void registerThreadLifeCycleListener(ThreadLifeCycleListener listener) {
        this.m_threadLifeCycleListeners.add((Object)listener);
    }

    public void removeThreadLifeCycleListener(ThreadLifeCycleListener listener) {
        this.m_threadLifeCycleListeners.remove((Object)listener);
    }

    public void fireBeginThreadEvent() {
        this.m_threadLifeCycleListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ThreadLifeCycleListener>(){

            public void inform(ThreadLifeCycleListener l) {
                l.beginThread();
            }
        });
    }

    public void fireBeginRunEvent() {
        this.m_threadLifeCycleListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ThreadLifeCycleListener>(){

            public void inform(ThreadLifeCycleListener l) {
                l.beginRun();
            }
        });
    }

    public void fireEndRunEvent() {
        this.m_threadLifeCycleListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ThreadLifeCycleListener>(){

            public void inform(ThreadLifeCycleListener l) {
                l.endRun();
            }
        });
    }

    public void fireBeginShutdownEvent() {
        this.m_threadLifeCycleListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ThreadLifeCycleListener>(){

            public void inform(ThreadLifeCycleListener l) {
                l.beginShutdown();
            }
        });
    }

    public void fireEndThreadEvent() {
        this.m_threadLifeCycleListeners.apply((ListenerSupport.Informer)new ListenerSupport.Informer<ThreadLifeCycleListener>(){

            public void inform(ThreadLifeCycleListener l) {
                l.endThread();
            }
        });
    }

    public void pushDispatchContext(DispatchContext dispatchContext) throws ShutdownException {
        if (this.m_shutdown) {
            this.m_shutdownReported = true;
            throw new ShutdownException("Thread has been shut down");
        }
        this.reportPendingDispatchContext();
        this.setTestLogMarker(dispatchContext.getLogMarker());
        DispatchContext existingContext = this.m_dispatchContextStack.peekTop();
        if (existingContext != null) {
            existingContext.setHasNestedContexts();
        }
        this.m_dispatchContextStack.push(dispatchContext);
    }

    public void popDispatchContext() {
        if (this.m_shutdownReported) {
            return;
        }
        DispatchContext dispatchContext = this.m_dispatchContextStack.pop();
        if (dispatchContext == null) {
            throw new AssertionError((Object)"DispatchContext stack unexpectedly empty");
        }
        DispatchContext parentDispatchContext = this.m_dispatchContextStack.peekTop();
        if (parentDispatchContext != null) {
            parentDispatchContext.getPauseTimer().add(dispatchContext.getPauseTimer());
        }
        this.m_statisticsForLastTest = dispatchContext.getStatisticsForTest();
        this.reportPendingDispatchContext();
        if (this.m_delayReports) {
            this.m_pendingDispatchContext = dispatchContext;
        } else {
            try {
                dispatchContext.report();
            }
            catch (DispatchContext.DispatchStateException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.setTestLogMarker(null);
    }

    public Statistics.StatisticsForTest getStatisticsForCurrentTest() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.peekTop();
        if (dispatchContext == null) {
            return null;
        }
        return dispatchContext.getStatisticsForTest();
    }

    public Statistics.StatisticsForTest getStatisticsForLastTest() {
        return this.m_statisticsForLastTest;
    }

    public void setDelayReports(boolean b) {
        if (!b) {
            this.reportPendingDispatchContext();
        }
        this.m_delayReports = b;
    }

    public void reportPendingDispatchContext() {
        if (this.m_pendingDispatchContext != null) {
            try {
                this.m_pendingDispatchContext.report();
            }
            catch (DispatchContext.DispatchStateException e) {
                throw new AssertionError((Object)e);
            }
            this.m_pendingDispatchContext = null;
        }
    }

    public void pauseClock() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.peekTop();
        if (dispatchContext != null) {
            dispatchContext.getPauseTimer().start();
        }
    }

    public void resumeClock() {
        DispatchContext dispatchContext = this.m_dispatchContextStack.peekTop();
        if (dispatchContext != null) {
            dispatchContext.getPauseTimer().stop();
        }
    }

    public void shutdown() {
        MarkerFactory.getIMarkerFactory().detachMarker(this.m_threadMarker.getName());
        this.m_shutdown = true;
    }

    public Marker getLogMarker() {
        return this.m_threadMarker;
    }

    private static final class DispatchContextStack {
        private final List<DispatchContext> m_stack = new ArrayList<DispatchContext>();

        private DispatchContextStack() {
        }

        public void push(DispatchContext dispatchContext) {
            this.m_stack.add(dispatchContext);
        }

        public DispatchContext pop() {
            int size = this.m_stack.size();
            if (size == 0) {
                return null;
            }
            return this.m_stack.remove(size - 1);
        }

        public DispatchContext peekTop() {
            int size = this.m_stack.size();
            if (size == 0) {
                return null;
            }
            return this.m_stack.get(size - 1);
        }
    }
}

