/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.jython;

import java.util.ArrayList;
import java.util.List;
import net.grinder.common.GrinderProperties;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.common.ScriptLocation;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Instrumenter;
import net.grinder.scriptengine.ScriptEngineService;
import net.grinder.scriptengine.jython.JythonScriptEngine;
import net.grinder.scriptengine.jython.instrumentation.dcr.Jython22Instrumenter;
import net.grinder.scriptengine.jython.instrumentation.dcr.Jython25Instrumenter;
import net.grinder.scriptengine.jython.instrumentation.dcr.Jython27Instrumenter;
import net.grinder.scriptengine.jython.instrumentation.traditional.TraditionalJythonInstrumenter;
import net.grinder.util.FileExtensionMatcher;
import net.grinder.util.weave.WeavingException;

public final class JythonScriptEngineService
implements ScriptEngineService {
    private final FileExtensionMatcher m_pyFileMatcher = new FileExtensionMatcher(".py");
    private final boolean m_forceDCRInstrumentation;
    private final DCRContext m_dcrContext;

    public JythonScriptEngineService(GrinderProperties properties, DCRContext dcrContext, ScriptLocation scriptLocation) {
        this.m_forceDCRInstrumentation = properties.getBoolean("grinder.dcrinstrumentation", false) || !this.m_pyFileMatcher.accept(scriptLocation.getFile());
        this.m_dcrContext = dcrContext;
    }

    public JythonScriptEngineService() {
        this.m_dcrContext = null;
        this.m_forceDCRInstrumentation = false;
    }

    public void noOp() {
    }

    public List<Instrumenter> createInstrumenters() throws EngineException {
        ArrayList<Instrumenter> instrumenters;
        block10: {
            instrumenters = new ArrayList<Instrumenter>();
            try {
                if (!this.m_forceDCRInstrumentation) {
                    try {
                        instrumenters.add((Instrumenter)new TraditionalJythonInstrumenter());
                    }
                    catch (EngineException e) {
                        this.noOp();
                    }
                    catch (VerifyError e) {
                        this.noOp();
                    }
                }
                if (this.m_dcrContext == null || instrumenters.size() != 0) break block10;
                try {
                    instrumenters.add((Instrumenter)new Jython27Instrumenter(this.m_dcrContext));
                }
                catch (WeavingException e) {
                    try {
                        instrumenters.add((Instrumenter)new Jython25Instrumenter(this.m_dcrContext));
                    }
                    catch (WeavingException ex) {
                        instrumenters.add((Instrumenter)new Jython22Instrumenter(this.m_dcrContext));
                    }
                }
            }
            catch (NoClassDefFoundError e) {
                this.noOp();
            }
        }
        return instrumenters;
    }

    public ScriptEngineService.ScriptEngine createScriptEngine(ScriptLocation script) throws EngineException {
        if (this.m_pyFileMatcher.accept(script.getFile())) {
            return new JythonScriptEngine(script);
        }
        return null;
    }
}

