/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.jython.instrumentation.dcr;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.script.Test;
import net.grinder.scriptengine.AbstractDCRInstrumenter;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Recorder;
import net.grinder.util.weave.Weaver;
import org.python.core.PyClass;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedConstructor;
import org.python.core.PyReflectedFunction;
import org.python.core.ReflectedArgs;

abstract class AbstractJythonDCRInstrumenter
extends AbstractDCRInstrumenter {
    protected AbstractJythonDCRInstrumenter(DCRContext context) {
        super(context);
    }

    private <T extends Member> List<T> extractJavaMethods(PyReflectedFunction pyReflectedFunction) throws NonInstrumentableTypeException {
        ReflectedArgs[] argsList = pyReflectedFunction.argslist;
        int nargs = pyReflectedFunction.nargs;
        ArrayList<Member> result = new ArrayList<Member>(nargs);
        for (int i = 0; i < nargs; ++i) {
            ReflectedArgs argument = argsList[i];
            try {
                Field dataField = argument.getClass().getField("data");
                dataField.setAccessible(true);
                result.add((Member)dataField.get(argument));
                continue;
            }
            catch (Exception e) {
                throw new NonInstrumentableTypeException(e.getMessage() + " [" + pyReflectedFunction + "]", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean instrument(Object target, Recorder recorder, Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        if (target instanceof PyObject) {
            this.disallowSelectiveFilter(filter);
            if (target instanceof PyInstance) {
                this.transform(recorder, (PyInstance)target);
                return true;
            } else if (target instanceof PyFunction) {
                this.transform(recorder, (PyFunction)target);
                return true;
            } else if (target instanceof PyMethod) {
                PyMethod pyMethod = (PyMethod)target;
                if (pyMethod.__func__ instanceof PyReflectedFunction) {
                    this.transform(recorder, (PyReflectedFunction)pyMethod.__func__, pyMethod.__self__.__tojava__(Object.class));
                    return true;
                } else {
                    this.transform(recorder, pyMethod);
                }
                return true;
            } else if (target instanceof PyClass) {
                this.transform(recorder, (PyClass)target);
                return true;
            } else if (target instanceof PyReflectedConstructor) {
                this.transform(recorder, (PyReflectedConstructor)target);
                return true;
            } else {
                if (!(target instanceof PyReflectedFunction)) throw new NonInstrumentableTypeException("Unknown PyObject:" + target.getClass());
                this.transform(recorder, (PyReflectedFunction)target, null);
            }
            return true;
        } else {
            if (!(target instanceof PyProxy)) return false;
            this.disallowSelectiveFilter(filter);
            this.transform(recorder, (PyProxy)target);
        }
        return true;
    }

    private void disallowSelectiveFilter(Test.InstrumentationFilter filter) throws NonInstrumentableTypeException {
        if (filter != ALL_INSTRUMENTATION) {
            throw new NonInstrumentableTypeException("The Jython instrumenters do not support selective instrumenters");
        }
    }

    protected abstract void transform(Recorder var1, PyInstance var2) throws NonInstrumentableTypeException;

    protected abstract void transform(Recorder var1, PyFunction var2) throws NonInstrumentableTypeException;

    protected abstract void transform(Recorder var1, PyClass var2) throws NonInstrumentableTypeException;

    protected abstract void transform(Recorder var1, PyProxy var2) throws NonInstrumentableTypeException;

    protected abstract void transform(Recorder var1, PyMethod var2) throws NonInstrumentableTypeException;

    protected final void transform(Recorder recorder, PyReflectedFunction target, Object instance) throws NonInstrumentableTypeException {
        List reflectedArguments = this.extractJavaMethods(target);
        if (instance != null) {
            for (Method m : reflectedArguments) {
                Class<?> c = instance.getClass();
                while (true) {
                    try {
                        this.getContext().add(instance, c.getDeclaredMethod(m.getName(), m.getParameterTypes()), Weaver.TargetSource.FIRST_PARAMETER, recorder);
                    }
                    catch (NoSuchMethodException e) {
                        if ((c = c.getSuperclass()) != null) continue;
                    }
                    break;
                }
            }
        } else {
            for (Method m : reflectedArguments) {
                this.getContext().add(m.getDeclaringClass(), m, Weaver.TargetSource.CLASS, recorder);
            }
        }
    }

    protected final void transform(Recorder recorder, PyReflectedConstructor target) throws NonInstrumentableTypeException {
        List reflectedArguments = this.extractJavaMethods((PyReflectedFunction)target);
        for (Constructor c : reflectedArguments) {
            this.getContext().add(c.getDeclaringClass(), c, recorder);
        }
    }

    protected final void instrumentPublicMethodsByName(Object target, String methodName, Recorder recorder, boolean includeSuperClassMethods) throws NonInstrumentableTypeException {
        this.instrumentPublicMethodsByName(target.getClass(), target, methodName, Weaver.TargetSource.FIRST_PARAMETER, recorder, includeSuperClassMethods);
    }

    protected final void instrumentPublicMethodsByName(Class<?> targetClass, Object target, String methodName, Weaver.TargetSource targetSource, Recorder recorder, boolean includeSuperClassMethods) throws NonInstrumentableTypeException {
        for (Method method : targetClass.getMethods()) {
            if (!includeSuperClassMethods && targetClass != method.getDeclaringClass() || !method.getName().equals(methodName) || !targetSource.canApply(method)) continue;
            this.getContext().add(target, method, targetSource, recorder);
        }
    }
}

