/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.scriptengine.jython.instrumentation.dcr;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.grinder.script.NonInstrumentableTypeException;
import net.grinder.scriptengine.DCRContext;
import net.grinder.scriptengine.Recorder;
import net.grinder.scriptengine.jython.instrumentation.dcr.AbstractJythonDCRInstrumenter;
import net.grinder.util.weave.Weaver;
import net.grinder.util.weave.WeavingException;
import org.python.core.PyClass;
import org.python.core.PyFunction;
import org.python.core.PyInstance;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.ThreadState;

public final class Jython27Instrumenter
extends AbstractJythonDCRInstrumenter {
    private final Transformer<PyInstance> m_pyInstanceTransformer;
    private final Transformer<PyFunction> m_pyFunctionTransformer;
    private final Transformer<PyProxy> m_pyProxyTransformer;
    private final Transformer<PyClass> m_pyClassTransformer;

    public Jython27Instrumenter(final DCRContext context) throws WeavingException {
        super(context);
        try {
            final ArrayList<Method> methodsForPyFunction = new ArrayList<Method>();
            for (Method method : PyFunction.class.getDeclaredMethods()) {
                if (!"__call__".equals(method.getName()) && !"function___call__".equals(method.getName()) || method.getParameterTypes().length < 1 || method.getParameterTypes()[0] != ThreadState.class) continue;
                methodsForPyFunction.add(method);
            }
            Jython27Instrumenter.assertAtLeastOneMethod(methodsForPyFunction);
            this.m_pyFunctionTransformer = new Transformer<PyFunction>(){

                @Override
                public void transform(Recorder recorder, PyFunction target) throws NonInstrumentableTypeException {
                    for (Method method : methodsForPyFunction) {
                        context.add((Object)target, method, Weaver.TargetSource.FIRST_PARAMETER, recorder);
                    }
                }
            };
            final ArrayList<Method> methodsForPyInstance = new ArrayList<Method>();
            for (Method method : PyFunction.class.getDeclaredMethods()) {
                if (!"__call__".equals(method.getName()) || method.getParameterTypes().length < 2 || method.getParameterTypes()[0] != ThreadState.class || method.getParameterTypes()[1] != PyObject.class) continue;
                methodsForPyInstance.add(method);
            }
            Jython27Instrumenter.assertAtLeastOneMethod(methodsForPyInstance);
            this.m_pyInstanceTransformer = new Transformer<PyInstance>(){

                @Override
                public void transform(Recorder recorder, PyInstance target) throws NonInstrumentableTypeException {
                    for (Method method : methodsForPyInstance) {
                        context.add((Object)target, method, Weaver.TargetSource.THIRD_PARAMETER, recorder);
                    }
                }
            };
            ArrayList<Method> methodsForPyMethod = new ArrayList<Method>();
            for (Method method : PyMethod.class.getDeclaredMethods()) {
                if (!"__call__".equals(method.getName()) && !"instancemethod___call__".equals(method.getName()) || method.getParameterTypes().length < 1 || method.getParameterTypes()[0] != ThreadState.class) continue;
                methodsForPyMethod.add(method);
            }
            Jython27Instrumenter.assertAtLeastOneMethod(methodsForPyMethod);
            final Method pyReflectedFunctionCall = PyReflectedFunction.class.getDeclaredMethod("__call__", PyObject.class, PyObject[].class, String[].class);
            final Method pyProxyPyInstanceMethod = PyProxy.class.getDeclaredMethod("_getPyInstance", new Class[0]);
            this.m_pyProxyTransformer = new Transformer<PyProxy>(){

                @Override
                public void transform(Recorder recorder, PyProxy target) throws NonInstrumentableTypeException {
                    PyObject pyInstance;
                    try {
                        pyInstance = (PyObject)pyProxyPyInstanceMethod.invoke((Object)target, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new NonInstrumentableTypeException("Could not call _getPyInstance", (Throwable)e);
                    }
                    for (Method method : methodsForPyInstance) {
                        context.add((Object)pyInstance, method, Weaver.TargetSource.THIRD_PARAMETER, recorder);
                    }
                    context.add((Object)pyInstance, pyReflectedFunctionCall, Weaver.TargetSource.SECOND_PARAMETER, recorder);
                }
            };
            final Method pyClassCall = PyClass.class.getDeclaredMethod("__call__", PyObject[].class, String[].class);
            this.m_pyClassTransformer = new Transformer<PyClass>(){

                @Override
                public void transform(Recorder recorder, PyClass target) throws NonInstrumentableTypeException {
                    context.add((Object)target, pyClassCall, Weaver.TargetSource.FIRST_PARAMETER, recorder);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new WeavingException("Jython 2.7 not found", (Throwable)e);
        }
    }

    private static void assertAtLeastOneMethod(List<Method> methods) throws WeavingException {
        if (methods.size() == 0) {
            throw new WeavingException("Jython 2.7 not found");
        }
    }

    public String getDescription() {
        return "byte code transforming instrumenter for Jython 2.7";
    }

    @Override
    protected void transform(Recorder recorder, PyInstance target) throws NonInstrumentableTypeException {
        this.m_pyInstanceTransformer.transform(recorder, target);
    }

    @Override
    protected void transform(Recorder recorder, PyFunction target) throws NonInstrumentableTypeException {
        this.m_pyFunctionTransformer.transform(recorder, target);
    }

    @Override
    protected void transform(Recorder recorder, PyClass target) throws NonInstrumentableTypeException {
        this.m_pyClassTransformer.transform(recorder, target);
    }

    @Override
    protected void transform(Recorder recorder, PyProxy target) throws NonInstrumentableTypeException {
        this.m_pyProxyTransformer.transform(recorder, target);
    }

    @Override
    protected void transform(Recorder recorder, PyMethod target) throws NonInstrumentableTypeException {
        if (target.__self__ == null) {
            this.instrumentPublicMethodsByName(target.__func__, "__call__", recorder, false);
        } else {
            this.instrumentPublicMethodsByName(target.__func__.getClass(), target.__self__, "__call__", Weaver.TargetSource.THIRD_PARAMETER, recorder, false);
        }
    }

    private static interface Transformer<T> {
        public void transform(Recorder var1, T var2) throws NonInstrumentableTypeException;
    }
}

