/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util;

import HTTPClient.NVPair;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.grinder.common.GrinderProperties;
import net.grinder.script.Grinder;
import net.grinder.script.InternalScriptContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;

public abstract class GrinderUtils {
    private static final Random random = new Random();

    public static int getThreadUniqId() {
        InternalScriptContext grinder = GrinderUtils.getGrinderInstance();
        GrinderProperties properties = grinder.getProperties();
        if (properties != null) {
            int totalProcessCount = properties.getInt("grinder.processes", 1);
            int totalThreadCount = properties.getInt("grinder.threads", 1);
            int agentNumber = grinder.getAgentNumber();
            int processNumber = grinder.getProcessNumber();
            int threadNumber = grinder.getThreadNumber();
            return agentNumber * totalProcessCount * totalThreadCount + processNumber * totalThreadCount + threadNumber;
        }
        return 0;
    }

    private static InternalScriptContext getGrinderInstance() {
        InternalScriptContext grinder = Grinder.grinder;
        if (grinder == null || grinder.getThreadNumber() == -1) {
            throw new RuntimeException("This method should be called in the worker thread context.");
        }
        return grinder;
    }

    public static NVPair[] nvs(Map<Object, Object> nvpairMap) {
        NVPair[] result = new NVPair[nvpairMap.size()];
        int i = 0;
        for (Map.Entry<Object, Object> each : nvpairMap.entrySet()) {
            result[i++] = new NVPair(each.getKey().toString(), each.getValue().toString());
        }
        return result;
    }

    public static <T> T any(List<T> from) {
        return from.get(random.nextInt(from.size()));
    }

    public static <T> T any(T[] from) {
        return from[random.nextInt(from.length)];
    }

    public static String getParam() {
        return GrinderUtils.getParam("");
    }

    public static String getParam(String defaultValue) {
        return System.getProperty("param", defaultValue);
    }

    public static int getParamInt() {
        return NumberUtils.toInt((String)GrinderUtils.getParam("0"), (int)0);
    }

    public static long getParamLong() {
        return NumberUtils.toLong((String)GrinderUtils.getParam("0"), (long)0L);
    }

    public static float getParamFloat() {
        return NumberUtils.toFloat((String)GrinderUtils.getParam("0"), (float)0.0f);
    }

    public static double getParamDouble() {
        return NumberUtils.toDouble((String)GrinderUtils.getParam("0"), (double)0.0);
    }

    public static boolean getParamBoolean() {
        return BooleanUtils.toBoolean((String)GrinderUtils.getParam("false"));
    }

    public static int getAgentCount() {
        return GrinderUtils.getGrinderInstance().getProperties().getInt("grinder.agents", 1);
    }

    public static int getProcessCount() {
        return GrinderUtils.getGrinderInstance().getProperties().getInt("grinder.processes", 1);
    }

    public static int getThreadCount() {
        return GrinderUtils.getGrinderInstance().getProperties().getInt("grinder.threads", 1);
    }
}

