/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.util.weave.j2se8;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.grinder.util.Pair;
import net.grinder.util.weave.Weaver;
import net.grinder.util.weave.WeavingException;
import net.grinder.util.weave.j2se8.PointCutRegistry;
import net.grinder.util.weave.j2se8.WeavingDetails;

public final class DCRWeaver
implements Weaver {
    private final Set<Class<?>> m_pendingClasses = new HashSet();
    private final PointCutRegistryImplementation m_pointCutRegistry = new PointCutRegistryImplementation();
    private final ClassFileTransformer m_transformer;
    private final Instrumentation m_instrumentation;
    private static final String s_classLoaderIdentity = Integer.toHexString(DCRWeaver.class.hashCode()) + ":";
    private static final AtomicLong s_nextLocation = new AtomicLong();

    public DCRWeaver(ClassFileTransformerFactory transformerFactory, Instrumentation instrumentation) {
        this.m_transformer = transformerFactory.create(this.m_pointCutRegistry);
        this.m_instrumentation = instrumentation;
        this.m_instrumentation.addTransformer(this.m_transformer, true);
    }

    public String weave(Constructor<?> constructor) {
        return this.m_pointCutRegistry.add(constructor);
    }

    public String weave(Method method, Weaver.TargetSource targetSource) throws WeavingException {
        if (!targetSource.canApply(method)) {
            throw new WeavingException("Insufficient parameters for " + targetSource + ": " + method.toString());
        }
        return this.m_pointCutRegistry.add(method, targetSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges() throws WeavingException {
        DCRWeaver dCRWeaver = this;
        synchronized (dCRWeaver) {
            if (this.m_pendingClasses.size() > 0) {
                try {
                    this.m_instrumentation.retransformClasses(this.m_pendingClasses.toArray(new Class[0]));
                }
                catch (UnmodifiableClassException e) {
                    throw new WeavingException("Failed to modify class", (Throwable)e);
                }
                this.m_pendingClasses.clear();
            }
        }
    }

    private static String generateLocationString() {
        return s_classLoaderIdentity + s_nextLocation.getAndIncrement();
    }

    private final class PointCutRegistryImplementation
    implements PointCutRegistry {
        private final Map<Pair<Member, Weaver.TargetSource>, String> m_wovenMembers = new HashMap<Pair<Member, Weaver.TargetSource>, String>();
        private final Map<String, Map<Constructor<?>, List<WeavingDetails>>> m_internalClassNameToConstructorToLocation = new HashMap();
        private final Map<String, Map<Method, List<WeavingDetails>>> m_internalClassNameToMethodToLocation = new HashMap<String, Map<Method, List<WeavingDetails>>>();

        private PointCutRegistryImplementation() {
        }

        @Override
        public Map<Constructor<?>, List<WeavingDetails>> getConstructorPointCutsForClass(String className) {
            return this.m_internalClassNameToConstructorToLocation.get(className);
        }

        @Override
        public Map<Method, List<WeavingDetails>> getMethodPointCutsForClass(String className) {
            return this.m_internalClassNameToMethodToLocation.get(className);
        }

        public String add(Constructor<?> constructor) {
            return this.add(constructor, Weaver.TargetSource.CLASS, this.m_internalClassNameToConstructorToLocation);
        }

        public String add(Method method, Weaver.TargetSource targetSource) {
            return this.add(method, targetSource, this.m_internalClassNameToMethodToLocation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends Member> String add(T member, Weaver.TargetSource targetSource, Map<String, Map<T, List<WeavingDetails>>> classNameToMemberToLocation) {
            Pair locationKey = Pair.of(member, (Object)targetSource);
            PointCutRegistryImplementation pointCutRegistryImplementation = this;
            synchronized (pointCutRegistryImplementation) {
                String alreadyWoven = this.m_wovenMembers.get(locationKey);
                if (alreadyWoven != null) {
                    return alreadyWoven;
                }
            }
            String className = member.getDeclaringClass().getName();
            String internalClassName = className.replace('.', '/');
            String location = DCRWeaver.generateLocationString();
            Object object = this;
            synchronized (object) {
                List<WeavingDetails> weavingDetailsList;
                Map<T, List<WeavingDetails>> memberToWeavingDetails;
                Map<T, List<WeavingDetails>> existingMap = classNameToMemberToLocation.get(internalClassName);
                if (existingMap != null) {
                    memberToWeavingDetails = existingMap;
                } else {
                    memberToWeavingDetails = new HashMap<T, List<WeavingDetails>>();
                    classNameToMemberToLocation.put(internalClassName, memberToWeavingDetails);
                }
                this.m_wovenMembers.put((Pair<Member, Weaver.TargetSource>)locationKey, location);
                List<WeavingDetails> existingList = memberToWeavingDetails.get(member);
                if (existingList != null) {
                    weavingDetailsList = existingList;
                } else {
                    weavingDetailsList = new ArrayList<WeavingDetails>();
                    memberToWeavingDetails.put(member, weavingDetailsList);
                }
                weavingDetailsList.add(new WeavingDetails(location, targetSource));
            }
            object = DCRWeaver.this;
            synchronized (object) {
                DCRWeaver.this.m_pendingClasses.add(member.getDeclaringClass());
            }
            return location;
        }
    }

    public static interface ClassFileTransformerFactory {
        public ClassFileTransformer create(PointCutRegistry var1);
    }
}

