/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.dns;

abstract class DnsUtils {
    private static final int INADDRSZ = 4;

    private DnsUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static <T> void exch(T[] a, int i, int j) {
        T swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    public static <T> T[] shuffle(T[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int r = i + (int)(Math.random() * (double)(N - i));
            DnsUtils.exch(a, i, r);
        }
        return a;
    }

    public static String numericToTextFormat(byte[] src) {
        return (src[0] & 0xFF) + "." + (src[1] & 0xFF) + "." + (src[2] & 0xFF) + "." + (src[3] & 0xFF);
    }

    public static byte[] textToNumericFormat(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        byte[] dst = new byte[4];
        char[] srcb = src.toCharArray();
        boolean sawDigit = false;
        int octets = 0;
        int i = 0;
        int cur = 0;
        while (i < srcb.length) {
            char ch;
            if (Character.isDigit(ch = srcb[i++])) {
                int sum = dst[cur] * 10 + (Character.digit(ch, 10) & 0xFF);
                if (sum > 255) {
                    return null;
                }
                dst[cur] = (byte)(sum & 0xFF);
                if (sawDigit) continue;
                if (++octets > 4) {
                    return null;
                }
                sawDigit = true;
                continue;
            }
            if (ch == '.' && sawDigit) {
                if (octets == 4) {
                    return null;
                }
                dst[++cur] = 0;
                sawDigit = false;
                continue;
            }
            return null;
        }
        if (octets < 4) {
            return null;
        }
        return dst;
    }
}

