/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ngrinder.dns.DnsUtils;
import org.ngrinder.dns.NameServiceProxy;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class LocalManagedDnsImpl
implements NameServiceProxy {
    public LocalManagedDnsImpl() {
        Cache cache = this.createCache();
        Lookup.setDefaultCache((Cache)cache, (int)1);
    }

    protected Cache createCache() {
        return new Cache();
    }

    @Override
    public InetAddress[] lookupAllHostAddr(String name) throws UnknownHostException {
        try {
            Lookup lookup = new Lookup(name, 1);
            Record[] records = lookup.run();
            if (records == null) {
                throw new UnknownHostException(name);
            }
            InetAddress[] array = new InetAddress[records.length];
            for (int i = 0; i < records.length; ++i) {
                ARecord a = (ARecord)records[i];
                array[i] = a.getAddress();
            }
            return array;
        }
        catch (TextParseException e) {
            throw new UnknownHostException(e.getMessage());
        }
    }

    @Override
    public String getHostByAddr(byte[] ip) throws UnknownHostException {
        try {
            String addr = DnsUtils.numericToTextFormat(ip);
            Record[] records = new Lookup(addr, 12).run();
            if (records == null) {
                throw new UnknownHostException(addr);
            }
            PTRRecord ptr = (PTRRecord)records[0];
            return ptr.getTarget().toString();
        }
        catch (TextParseException e) {
            throw new UnknownHostException(e.getMessage());
        }
    }
}

