/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.ngrinder.dns.DnsUtils;
import org.ngrinder.dns.LocalManagedDnsImpl;
import org.ngrinder.dns.NameServiceProxy;
import org.ngrinder.dns.NameStore;

public class LocalManagedDnsProxy
implements NameServiceProxy {
    private final NameServiceProxy defaultDnsImpl = new LocalManagedDnsImpl();
    private final NameStore instance = NameStore.getInstance();

    @Override
    public String getHostByAddr(byte[] ip) throws UnknownHostException {
        String hostName = this.instance.getReveredHost(InetAddress.getByAddress(ip));
        if (hostName == null) {
            return this.defaultDnsImpl.getHostByAddr(ip);
        }
        return hostName;
    }

    @Override
    public InetAddress[] lookupAllHostAddr(String name) throws UnknownHostException {
        Set<InetAddress> ipAddresses = this.instance.get(name);
        if (ipAddresses != null) {
            return DnsUtils.shuffle(ipAddresses.toArray(new InetAddress[0]));
        }
        return this.defaultDnsImpl.lookupAllHostAddr(name);
    }
}

