/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.dns;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;

public interface NameServiceProxy
extends InvocationHandler {
    public InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

    public String getHostByAddr(byte[] var1) throws UnknownHostException;

    public static void set(NameServiceProxy dns) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException {
        List<Object> proxyInstance;
        Field nameServiceField;
        Class<InetAddress> inetAddressClass = InetAddress.class;
        try {
            Class<?> originNameServiceInterface = Class.forName("java.net.InetAddress$NameService");
            nameServiceField = inetAddressClass.getDeclaredField("nameService");
            proxyInstance = Proxy.newProxyInstance(originNameServiceInterface.getClassLoader(), new Class[]{originNameServiceInterface}, (InvocationHandler)dns);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            Class<?> originNameServiceInterface = Class.forName("sun.net.spi.nameservice.NameService");
            nameServiceField = inetAddressClass.getDeclaredField("nameServices");
            proxyInstance = Collections.singletonList(Proxy.newProxyInstance(originNameServiceInterface.getClassLoader(), new Class[]{originNameServiceInterface}, (InvocationHandler)dns));
        }
        nameServiceField.setAccessible(true);
        nameServiceField.set(inetAddressClass, proxyInstance);
        nameServiceField.setAccessible(false);
    }

    @Override
    default public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.getName().equalsIgnoreCase("lookupAllHostAddr") ? this.lookupAllHostAddr((String)args[0]) : this.getHostByAddr((byte[])args[0]);
    }
}

