/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ngrinder.dns.DnsUtils;

public class NameStore {
    private static NameStore singleton;
    private final Map<String, Set<InetAddress>> globalNames = new ConcurrentHashMap<String, Set<InetAddress>>();

    private NameStore() {
    }

    public void initFromSystemProperty() {
        String hostPair = System.getProperty("ngrinder.etc.hosts");
        if (!DnsUtils.isEmpty(hostPair)) {
            String[] hostPairs;
            for (String pair : hostPairs = hostPair.split(",")) {
                String[] each = pair.split(":");
                if (each.length != 2 || DnsUtils.isEmpty(each[0]) || DnsUtils.isEmpty(each[1])) continue;
                singleton.put(each[0].trim(), each[1].trim());
            }
        }
    }

    public static NameStore getInstance() {
        if (singleton == null) {
            singleton = new NameStore();
            singleton.initFromSystemProperty();
            try {
                Security.setProperty("networkaddress.cache.ttl", "0");
            }
            catch (Exception e) {
                NameStore.noOp();
            }
        }
        return singleton;
    }

    void reset() {
        this.globalNames.clear();
        this.initFromSystemProperty();
    }

    private static void noOp() {
    }

    public void put(String hostName, String ipAddress) {
        Set ipAddresses = this.globalNames.computeIfAbsent(hostName, k -> new HashSet());
        try {
            InetAddress address = InetAddress.getByAddress(DnsUtils.textToNumericFormat(ipAddress));
            ipAddresses.add(address);
        }
        catch (UnknownHostException ignored) {
            NameStore.noOp();
        }
    }

    public void remove(String hostName) {
        this.globalNames.remove(hostName);
    }

    public Set<InetAddress> get(String hostName) {
        return this.globalNames.get(hostName);
    }

    public String getReveredHost(InetAddress ip) {
        for (String hostName : this.globalNames.keySet()) {
            if (!this.globalNames.get(hostName).contains(ip)) continue;
            return hostName;
        }
        return null;
    }
}

