/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http;

import HTTPClient.NVPair;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.grinder.plugin.http.HTTPPlugin;
import net.grinder.script.InvalidContextException;
import net.grinder.script.NoSuchStatisticException;
import net.grinder.script.Statistics;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.impl.cookie.RFC6265StrictSpec;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.AsyncRequestBuilder;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.util.Timeout;
import org.ngrinder.http.HTTPRequestControl;
import org.ngrinder.http.HTTPRequester;
import org.ngrinder.http.HTTPResponse;
import org.ngrinder.http.TimeToFirstByteHolder;
import org.ngrinder.http.cookie.ThreadContextCookieStore;
import org.ngrinder.http.method.HTTPDelete;
import org.ngrinder.http.method.HTTPGet;
import org.ngrinder.http.method.HTTPHead;
import org.ngrinder.http.method.HTTPPatch;
import org.ngrinder.http.method.HTTPPost;
import org.ngrinder.http.method.HTTPPut;
import org.ngrinder.http.util.ContentTypeUtils;
import org.ngrinder.http.util.JsonUtils;
import org.ngrinder.http.util.PairListConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRequest
implements HTTPHead,
HTTPGet,
HTTPPost,
HTTPPut,
HTTPPatch,
HTTPDelete {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPRequest.class);
    private static final CookieStore COOKIE_STORE = ThreadContextCookieStore.INSTANCE;
    private static final CookieSpec COOKIE_SPEC = new RFC6265StrictSpec();
    private HTTPRequester requester;
    private CookieOrigin cookieOrigin;
    private int readBytes = -1;
    private HttpVersionPolicy versionPolicy = HttpVersionPolicy.NEGOTIATE;
    private List<Header> headers = Collections.emptyList();

    public HTTPRequest() {
        this.requester = new HTTPRequester.Builder().build();
    }

    @Override
    public HTTPResponse HEAD(String uri, List<NameValuePair> params, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithParam("HEAD", uri, params, headers));
    }

    @Override
    public HTTPResponse GET(String uri, List<NameValuePair> params, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithParam("GET", uri, params, headers));
    }

    @Override
    public HTTPResponse POST(String uri, byte[] content, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithBody("POST", uri, content, headers));
    }

    @Override
    public HTTPResponse POST(String uri, List<NameValuePair> params, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithParam("POST", uri, params, headers));
    }

    @Override
    public HTTPResponse POST(String uri, Map<?, ?> params, List<Header> headers) {
        List<Header> actualHeaders;
        List<Header> list = actualHeaders = headers.isEmpty() ? this.headers : headers;
        if (ContentTypeUtils.getContentType(actualHeaders).isSameMimeType(ContentType.APPLICATION_JSON)) {
            return this.POST(uri, JsonUtils.toJson(params).getBytes(), actualHeaders);
        }
        return this.POST(uri, PairListConvertUtils.convert(params, BasicNameValuePair::new), actualHeaders);
    }

    @Override
    public HTTPResponse POST(String uri, AsyncEntityProducer asyncEntityProducer, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithEntity("POST", uri, asyncEntityProducer, headers));
    }

    @Override
    public HTTPResponse PUT(String uri, byte[] content, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithBody("PUT", uri, content, headers));
    }

    @Override
    public HTTPResponse PUT(String uri, List<NameValuePair> params, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithParam("PUT", uri, params, headers));
    }

    @Override
    public HTTPResponse PUT(String uri, Map<?, ?> params, List<Header> headers) {
        List<Header> actualHeaders;
        List<Header> list = actualHeaders = headers.isEmpty() ? this.headers : headers;
        if (ContentTypeUtils.getContentType(actualHeaders).isSameMimeType(ContentType.APPLICATION_JSON)) {
            return this.PUT(uri, JsonUtils.toJson(params).getBytes(), headers);
        }
        return this.PUT(uri, PairListConvertUtils.convert(params, BasicNameValuePair::new), actualHeaders);
    }

    @Override
    public HTTPResponse PUT(String uri, AsyncEntityProducer asyncEntityProducer, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithEntity("PUT", uri, asyncEntityProducer, headers));
    }

    @Override
    public HTTPResponse PATCH(String uri, byte[] content, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithBody("PATCH", uri, content, headers));
    }

    @Override
    public HTTPResponse PATCH(String uri, List<NameValuePair> params, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithParam("PATCH", uri, params, headers));
    }

    @Override
    public HTTPResponse PATCH(String uri, Map<?, ?> params, List<Header> headers) {
        List<Header> actualHeaders;
        List<Header> list = actualHeaders = headers.isEmpty() ? this.headers : headers;
        if (ContentTypeUtils.getContentType(actualHeaders).isSameMimeType(ContentType.APPLICATION_JSON)) {
            return this.PATCH(uri, JsonUtils.toJson(params).getBytes(), headers);
        }
        return this.PATCH(uri, PairListConvertUtils.convert(params, BasicNameValuePair::new), actualHeaders);
    }

    @Override
    public HTTPResponse PATCH(String uri, AsyncEntityProducer asyncEntityProducer, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithEntity("PATCH", uri, asyncEntityProducer, headers));
    }

    @Override
    public HTTPResponse DELETE(String uri, List<NameValuePair> params, List<Header> headers) {
        return this.doRequest(uri, this.createRequestWithParam("DELETE", uri, params, headers));
    }

    private HTTPResponse doRequest(String uri, AsyncRequestProducer producer) {
        AsyncClientEndpoint endpoint = this.getEndpoint(uri);
        try {
            BasicResponseConsumer consumer = new BasicResponseConsumer((AsyncEntityConsumer)new BasicAsyncEntityConsumer());
            Future messageFuture = endpoint.execute(producer, (AsyncResponseConsumer)consumer, null);
            Message message = (Message)messageFuture.get();
            endpoint.releaseAndReuse();
            this.processResponseCookies(((HttpResponse)message.getHead()).headerIterator("Set-Cookie"));
            this.aggregate((Message<HttpResponse, byte[]>)message);
            this.summarize(uri, (Message<HttpResponse, byte[]>)message);
            return HTTPResponse.of((Message<HttpResponse, byte[]>)message);
        }
        catch (Exception e) {
            endpoint.releaseAndDiscard();
            throw new RuntimeException(e);
        }
    }

    private AsyncClientEndpoint getEndpoint(String uri) {
        try {
            HttpHost httpHost = HttpHost.create((URI)URI.create(uri));
            Timeout connectionTimeout = Timeout.ofMilliseconds((long)HTTPRequestControl.getConnectionTimeout());
            long start = System.currentTimeMillis();
            AsyncClientEndpoint endpoint = (AsyncClientEndpoint)this.requester.connect(httpHost, connectionTimeout).get();
            long end = System.currentTimeMillis();
            Statistics statistics = this.getStatistics();
            if (statistics.isTestInProgress()) {
                Statistics.StatisticsForTest statisticsForTest = statistics.getForCurrentTest();
                statisticsForTest.setLong("httpplugin.connectTime", end - start);
            }
            return endpoint;
        }
        catch (InterruptedException | ExecutionException | InvalidContextException | NoSuchStatisticException e) {
            throw new RuntimeException(e);
        }
    }

    private Statistics getStatistics() {
        return HTTPPlugin.getPlugin().getPluginProcessContext().getScriptContext().getStatistics();
    }

    private void aggregate(Message<HttpResponse, byte[]> message) {
        Statistics statistics = this.getStatistics();
        if (!statistics.isTestInProgress()) {
            return;
        }
        try {
            Statistics.StatisticsForTest statisticsForTest = statistics.getForCurrentTest();
            statisticsForTest.setLong("httpplugin.responseStatus", (long)((HttpResponse)message.getHead()).getCode());
            if (((HttpResponse)message.getHead()).getCode() >= 400) {
                statisticsForTest.addLong("httpplugin.responseErrors", 1L);
            }
            statisticsForTest.addLong("httpplugin.responseLength", message.getBody() == null ? 0L : (long)((byte[])message.getBody()).length);
            statisticsForTest.addLong("httpplugin.firstByteTime", TimeToFirstByteHolder.getTotal() + statisticsForTest.getLong("httpplugin.connectTime"));
        }
        catch (Exception e) {
            LOGGER.error("Fail to aggregate HTTP statistics", (Throwable)e);
        }
    }

    private void summarize(String uri, Message<HttpResponse, byte[]> message) {
        Logger logger = HTTPPlugin.getPlugin().getPluginProcessContext().getScriptContext().getLogger();
        logger.info("{} -> {} {}, {} bytes", new Object[]{uri, ((HttpResponse)message.getHead()).getCode(), ((HttpResponse)message.getHead()).getReasonPhrase(), message.getBody() == null ? 0 : ((byte[])message.getBody()).length});
    }

    private AsyncRequestBuilder createRequest(String method, String uri, List<Header> headers) {
        AsyncRequestBuilder builder = AsyncRequestBuilder.create((String)method).setUri(uri);
        List<Header> actualHeaders = headers.isEmpty() ? this.headers : headers;
        actualHeaders.forEach(arg_0 -> ((AsyncRequestBuilder)builder).addHeader(arg_0));
        this.getMatchedCookies(uri).forEach(arg_0 -> ((AsyncRequestBuilder)builder).addHeader(arg_0));
        return builder;
    }

    private AsyncRequestProducer createRequestWithParam(String method, String uri, List<NameValuePair> params, List<Header> headers) {
        AsyncRequestBuilder builder = this.createRequest(method, uri, headers);
        params.forEach(arg_0 -> ((AsyncRequestBuilder)builder).addParameter(arg_0));
        return builder.build();
    }

    private AsyncRequestProducer createRequestWithBody(String method, String uri, byte[] content, List<Header> headers) {
        AsyncRequestBuilder builder = this.createRequest(method, uri, headers);
        builder.setEntity(content, ContentTypeUtils.getContentType(headers));
        return builder.build();
    }

    private AsyncRequestProducer createRequestWithEntity(String method, String uri, AsyncEntityProducer asyncEntityProducer, List<Header> headers) {
        AsyncRequestBuilder builder = this.createRequest(method, uri, headers);
        builder.setEntity(asyncEntityProducer);
        return builder.build();
    }

    private List<Header> getMatchedCookies(String uriString) {
        URI uri = URI.create(uriString);
        int port = uri.getPort();
        if (port == -1) {
            port = 80;
        }
        boolean isSecure = uri.getScheme().equalsIgnoreCase("https");
        this.cookieOrigin = new CookieOrigin(uri.getHost(), port, uri.getPath(), isSecure);
        List<Cookie> cookies = COOKIE_STORE.getCookies();
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        boolean expired = false;
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!COOKIE_SPEC.match(cookie, this.cookieOrigin)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cookie {} match {}", (Object)cookie, (Object)this.cookieOrigin);
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cookie {} expired", (Object)cookie);
            }
            expired = true;
        }
        if (expired) {
            COOKIE_STORE.clearExpired(now);
        }
        if (!matchedCookies.isEmpty()) {
            return COOKIE_SPEC.formatCookies(matchedCookies);
        }
        return Collections.emptyList();
    }

    private void processResponseCookies(Iterator<Header> iterator) {
        iterator.forEachRemaining(header -> {
            try {
                List<Cookie> cookies = COOKIE_SPEC.parse((Header)header, this.cookieOrigin);
                for (Cookie cookie : cookies) {
                    try {
                        COOKIE_SPEC.validate(cookie, this.cookieOrigin);
                        COOKIE_STORE.addCookie(cookie);
                    }
                    catch (MalformedCookieException e) {
                        LOGGER.warn("Cookie rejected [{}] {}", (Object)cookie, (Object)e.getMessage());
                    }
                }
            }
            catch (MalformedCookieException ex) {
                LOGGER.warn("Invalid cookie header: \"{}\". {}", header, (Object)ex.getMessage());
            }
        });
    }

    public void setVersionPolicy(HttpVersionPolicy versionPolicy) {
        this.versionPolicy = versionPolicy;
        this.requester.setVersionPolicy(versionPolicy);
    }

    public int getReadBytes() {
        return this.readBytes;
    }

    public void setReadBytes(int readBytes) {
        this.readBytes = readBytes;
        try {
            this.requester.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.requester = new HTTPRequester.Builder().setReadBytes(this.readBytes).setVersionPolicy(this.versionPolicy).build();
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.setHeaders(PairListConvertUtils.convert(headers, BasicHeader::new));
    }

    public void setHeaders(NVPair[] nvPairHeaders) {
        this.setHeaders(PairListConvertUtils.convert(nvPairHeaders, BasicHeader::new));
    }

    static {
        HTTPPlugin.getPlugin();
    }
}

