/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import net.grinder.common.GrinderProperties;
import net.grinder.script.Grinder;
import net.grinder.util.Pair;
import org.apache.commons.lang.time.StopWatch;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiatorFactory;
import org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import org.apache.hc.core5.http2.ssl.H2ClientTlsStrategy;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Timeout;
import org.ngrinder.http.HTTPRequestControl;
import org.ngrinder.http.PartialContentLengthStrategy;
import org.ngrinder.http.ThreadAwareConnPool;
import org.ngrinder.http.TimeToFirstByteHolder;
import org.ngrinder.http.TrustAllManager;

public class HTTPRequester
extends HttpAsyncRequester {
    private static final ThreadAwareConnPool<HttpHost, IOSession> connPool = new ThreadAwareConnPool();
    private HttpVersionPolicy versionPolicy;

    public HTTPRequester(IOReactorConfig ioReactorConfig, IOEventHandlerFactory ioEventHandlerFactory, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener ioSessionListener, HttpVersionPolicy versionPolicy) {
        super(ioReactorConfig, ioEventHandlerFactory, ioSessionDecorator, exceptionCallback, ioSessionListener, connPool);
        this.versionPolicy = versionPolicy == null ? HttpVersionPolicy.NEGOTIATE : versionPolicy;
    }

    public static void reset() {
        connPool.clear();
    }

    protected Future<AsyncClientEndpoint> doConnect(HttpHost host, Timeout timeout, Object attachment, FutureCallback<AsyncClientEndpoint> callback) {
        return super.doConnect(host, timeout, attachment != null ? attachment : this.versionPolicy, callback);
    }

    public void setVersionPolicy(HttpVersionPolicy versionPolicy) {
        this.versionPolicy = versionPolicy;
    }

    public static class Builder {
        private HttpVersionPolicy versionPolicy = HttpVersionPolicy.NEGOTIATE;
        private long readBytes = -1L;

        Builder() {
        }

        public Builder setReadBytes(long readBytes) {
            this.readBytes = readBytes;
            return this;
        }

        public Builder setVersionPolicy(HttpVersionPolicy versionPolicy) {
            this.versionPolicy = versionPolicy;
            return this;
        }

        private IOReactorConfig ioReactorConfig() {
            GrinderProperties properties = Grinder.grinder.getProperties();
            int totalThreadCount = 1;
            if (properties != null) {
                totalThreadCount = properties.getInt("grinder.threads", 1);
            }
            int ioThreadCount = totalThreadCount / 100 + 1;
            return IOReactorConfig.custom().setIoThreadCount(ioThreadCount).setSoTimeout(Timeout.ofMilliseconds((long)HTTPRequestControl.getSocketTimeout())).build();
        }

        private IOEventHandlerFactory ioEventHandlerFactory() {
            SSLContext sslContext;
            RequestHandlerRegistry registry = new RequestHandlerRegistry();
            ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory = new ClientHttp1StreamDuplexerFactory(HttpProcessors.client(), Http1Config.DEFAULT, CharCodingConfig.DEFAULT, null, null, null, (ContentLengthStrategy)new PartialContentLengthStrategy(this.readBytes), null, null);
            ClientH2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientH2StreamMultiplexerFactory(H2Processors.client(), (HandlerFactory)new DefaultAsyncPushConsumerFactory((HttpRequestMapper)registry), H2Config.DEFAULT, CharCodingConfig.DEFAULT, null);
            try {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            return new ClientHttpProtocolNegotiatorFactory(http1StreamHandlerFactory, http2StreamHandlerFactory, null, (TlsStrategy)new H2ClientTlsStrategy(sslContext), null);
        }

        private IOSessionListener ioSessionListener() {
            return new IOSessionListener(){
                private final Map<IOSession, Pair<StopWatch, Boolean>> stopWatchAndTlsFlagMap = new HashMap<IOSession, Pair<StopWatch, Boolean>>();

                public void connected(IOSession session) {
                    Pair stopWatchAndTlsFlag = this.stopWatchAndTlsFlagMap.get(session);
                    if (stopWatchAndTlsFlag == null) {
                        stopWatchAndTlsFlag = Pair.of((Object)new StopWatch(), (Object)false);
                        ((StopWatch)stopWatchAndTlsFlag.getFirst()).start();
                    } else {
                        stopWatchAndTlsFlag = Pair.of((Object)stopWatchAndTlsFlag.getFirst(), (Object)false);
                    }
                    this.stopWatchAndTlsFlagMap.put(session, (Pair<StopWatch, Boolean>)stopWatchAndTlsFlag);
                }

                public void startTls(IOSession session) {
                    Pair stopWatchAndTlsFlag = Pair.of((Object)new StopWatch(), (Object)true);
                    ((StopWatch)stopWatchAndTlsFlag.getFirst()).start();
                    this.stopWatchAndTlsFlagMap.put(session, (Pair<StopWatch, Boolean>)stopWatchAndTlsFlag);
                }

                public void inputReady(IOSession session) {
                    Pair<StopWatch, Boolean> stopWatchAndTlsFlag = this.stopWatchAndTlsFlagMap.get(session);
                    if (stopWatchAndTlsFlag == null) {
                        return;
                    }
                    StopWatch stopWatch = (StopWatch)stopWatchAndTlsFlag.getFirst();
                    boolean isTlsEvent = (Boolean)stopWatchAndTlsFlag.getSecond();
                    if (isTlsEvent) {
                        return;
                    }
                    stopWatch.stop();
                    long timeToFirstByte = stopWatch.getTime();
                    stopWatch.reset();
                    TimeToFirstByteHolder.accumulate(timeToFirstByte);
                    this.stopWatchAndTlsFlagMap.remove(session);
                }

                public void outputReady(IOSession session) {
                }

                public void timeout(IOSession session) {
                }

                public void exception(IOSession session, Exception ex) {
                }

                public void disconnected(IOSession session) {
                }
            };
        }

        public HTTPRequester build() {
            HTTPRequester requester = new HTTPRequester(this.ioReactorConfig(), this.ioEventHandlerFactory(), null, null, this.ioSessionListener(), this.versionPolicy);
            requester.start();
            return requester;
        }
    }
}

