/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.ProtocolVersion;

public class HTTPResponse {
    private static final byte[] EMPTY_BODY = new byte[0];
    private final Message<HttpResponse, byte[]> message;
    private String bodyText = "";

    HTTPResponse(Message<HttpResponse, byte[]> message) {
        this.message = message;
    }

    public byte[] getBodyBytes() {
        return this.message.getBody() == null ? EMPTY_BODY : (byte[])this.message.getBody();
    }

    public String getBodyText() {
        return this.getBodyText(Charset.defaultCharset());
    }

    public String getBodyText(Charset charset) {
        if (this.bodyText.isEmpty()) {
            this.bodyText = new String(this.getBodyBytes(), charset);
        }
        return this.bodyText;
    }

    public <T> T getBody(Function<String, T> converter) {
        return converter.apply(this.getBodyText());
    }

    public int getStatusCode() {
        return ((HttpResponse)this.message.getHead()).getCode();
    }

    public ProtocolVersion getVersion() {
        return ((HttpResponse)this.message.getHead()).getVersion();
    }

    public Header getHeader(String name) {
        return ((HttpResponse)this.message.getHead()).getFirstHeader(name);
    }

    public List<Header> getHeaders() {
        return Arrays.asList(((HttpResponse)this.message.getHead()).getHeaders());
    }

    public List<Header> getHeaders(String name) {
        return Arrays.asList(((HttpResponse)this.message.getHead()).getHeaders(name));
    }

    public static HTTPResponse of(Message<HttpResponse, byte[]> message) {
        return new HTTPResponse(message);
    }
}

