/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import net.grinder.util.NoOp;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.ngrinder.http.EmptyConnPoolControl;

public class ThreadAwareConnPool<T, C extends ModalCloseable>
extends EmptyConnPoolControl<T, C>
implements ManagedConnPool<T, C> {
    private final ThreadLocal<Set<PoolEntry<T, C>>> leased = ThreadLocal.withInitial(HashSet::new);
    private final ThreadLocal<LinkedList<PoolEntry<T, C>>> available = ThreadLocal.withInitial(LinkedList::new);

    public Future<PoolEntry<T, C>> lease(T route, Object state, Timeout requestTimeout, FutureCallback<PoolEntry<T, C>> callback) {
        PoolEntry poolEntry = this.getAvailable().stream().filter(entry -> entry.getRoute().equals(route)).findAny().orElseGet(() -> new PoolEntry(route, (TimeValue)Timeout.DISABLED));
        this.getLeased().add(poolEntry);
        BasicFuture future = new BasicFuture(callback);
        future.completed((Object)poolEntry);
        return future;
    }

    public void release(PoolEntry<T, C> entry, boolean reusable) {
        if (entry == null) {
            return;
        }
        if (this.getLeased().remove(entry)) {
            boolean keepAlive;
            boolean bl = keepAlive = entry.hasConnection() && reusable;
            if (keepAlive) {
                this.getAvailable().addFirst(entry);
            } else {
                entry.discardConnection(CloseMode.IMMEDIATE);
            }
        }
    }

    public void clear() {
        Stream entryStream = Stream.concat(this.getLeased().stream(), this.getAvailable().stream());
        entryStream.forEach(entry -> entry.discardConnection(CloseMode.IMMEDIATE));
        this.getLeased().clear();
        this.getAvailable().clear();
    }

    public void close(CloseMode closeMode) {
        NoOp.noOp();
    }

    public void close() throws IOException {
        this.close(CloseMode.IMMEDIATE);
    }

    public Set<PoolEntry<T, C>> getLeased() {
        return this.leased.get();
    }

    public LinkedList<PoolEntry<T, C>> getAvailable() {
        return this.available.get();
    }
}

