/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http.cookie;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;

public class Cookie {
    private final BasicClientCookie realCookie;

    public Cookie(String name, String value) {
        this.realCookie = new BasicClientCookie(name, value);
    }

    public Cookie(String name, String value, String domain, String path, int expire) {
        this.realCookie = new BasicClientCookie(name, value);
        this.realCookie.setDomain(domain);
        this.realCookie.setPath(path);
        if (expire >= 0) {
            this.realCookie.setExpiryDate(Date.from(Instant.now().plus((long)expire, ChronoUnit.SECONDS)));
        }
    }

    public static Cookie from(org.apache.hc.client5.http.cookie.Cookie realCookie) {
        Cookie cookie = new Cookie(realCookie.getName(), realCookie.getValue());
        cookie.realCookie.setDomain(realCookie.getDomain());
        cookie.realCookie.setPath(realCookie.getPath());
        cookie.realCookie.setExpiryDate(realCookie.getExpiryDate());
        return cookie;
    }

    BasicClientCookie getRealCookie() {
        return this.realCookie;
    }

    public String toString() {
        return "Cookie(name: " + this.realCookie.getName() + ", value: " + this.realCookie.getValue() + ", domain: " + this.realCookie.getDomain() + ", path: " + this.realCookie.getPath() + ", expire: " + this.realCookie.getExpiryDate() + ")";
    }
}

