/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http.cookie;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.ngrinder.http.cookie.Cookie;
import org.ngrinder.http.cookie.ThreadContextCookieStore;

public class CookieManager {
    private static final CookieStore cookieStore = ThreadContextCookieStore.INSTANCE;

    public static void addCookies(List<Cookie> cookies) {
        cookies.forEach(CookieManager::addCookie);
    }

    public static void addCookie(Cookie cookie) {
        cookieStore.addCookie(cookie.getRealCookie());
    }

    public static List<Cookie> getCookies() {
        return cookieStore.getCookies().stream().map(Cookie::from).collect(Collectors.toList());
    }

    public static void reset() {
        cookieStore.clear();
    }
}

