/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http.multipart;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.entity.FileEntityProducer;
import org.ngrinder.http.multipart.DelegateDataStreamChannel;
import org.ngrinder.http.multipart.MultipartEntity;

public class FileMultipartEntity
implements MultipartEntity {
    private final String name;
    private final ContentType contentType;
    private final FileEntityProducer fileEntityProducer;
    private final AtomicBoolean isBegin;
    private final String multipartHeader;
    private boolean remaining = true;

    public FileMultipartEntity(String name, File file, ContentType contentType) {
        this.name = name;
        this.contentType = contentType;
        this.fileEntityProducer = new FileEntityProducer(file, contentType);
        this.isBegin = new AtomicBoolean(false);
        this.multipartHeader = this.generateMultipartHeader(name, file.getName(), contentType);
    }

    public FileMultipartEntity(String name, File file) {
        this(name, file, ContentType.APPLICATION_OCTET_STREAM);
    }

    private String generateMultipartHeader(String name, String fileName, ContentType contentType) {
        return "-----------bGd5dW5vZG1pYm91anl1ZW9nbm55bm5vZ2p1ZQ\r\nContent-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"" + "\r\n" + "Content-Type: " + contentType + "\r\n" + "\r\n";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        if (this.isBegin.compareAndSet(false, true)) {
            channel.write(ByteBuffer.wrap(this.multipartHeader.getBytes()));
        }
        DelegateDataStreamChannel delegateChannel = DelegateDataStreamChannel.from(channel);
        this.fileEntityProducer.produce((DataStreamChannel)delegateChannel);
        if (delegateChannel.isEnd()) {
            channel.write(ByteBuffer.wrap("\r\n".getBytes()));
            this.remaining = false;
        }
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining;
    }

    @Override
    public long getContentLength() {
        return this.fileEntityProducer.getContentLength() + (long)this.multipartHeader.length();
    }

    @Override
    public void releaseResources() {
        this.fileEntityProducer.releaseResources();
    }
}

