/*
 * Decompiled with CFR 0.152.
 */
package org.ngrinder.http.multipart;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.ngrinder.http.multipart.BasicMultipartEntity;
import org.ngrinder.http.multipart.FileMultipartEntity;
import org.ngrinder.http.multipart.MultipartEntity;
import org.ngrinder.http.multipart.MultipartEntityProducer;

public class MultipartEntityBuilder {
    private final List<MultipartEntity> multipartEntities = new ArrayList<MultipartEntity>();

    private MultipartEntityBuilder() {
    }

    public static MultipartEntityBuilder create() {
        return new MultipartEntityBuilder();
    }

    public AsyncEntityProducer build() {
        return new MultipartEntityProducer(this.multipartEntities);
    }

    public MultipartEntityBuilder addEntity(MultipartEntity multipartEntity) {
        this.multipartEntities.add(multipartEntity);
        return this;
    }

    public MultipartEntityBuilder addEntity(String name, CharSequence value, ContentType contentType) {
        this.multipartEntities.add(new BasicMultipartEntity(name, value, contentType));
        return this;
    }

    public MultipartEntityBuilder addEntity(String name, CharSequence value) {
        return this.addEntity(name, value, ContentType.TEXT_PLAIN);
    }

    public MultipartEntityBuilder addEntity(String name, File file, ContentType contentType) {
        this.multipartEntities.add(new FileMultipartEntity(name, file, contentType));
        return this;
    }

    public MultipartEntityBuilder addEntity(String name, File file) {
        return this.addEntity(name, file, ContentType.APPLICATION_OCTET_STREAM);
    }
}

